/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.HMAC;
import com.soywiz.krypto.Hash;
import com.soywiz.krypto.Hasher;
import com.soywiz.krypto.SHA1;
import com.soywiz.krypto.SHA256;
import com.soywiz.krypto.SHA512;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/soywiz/krypto/PBKDF2;", "", "()V", "Companion", "krypto_release"})
public final class PBKDF2 {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0010\u001a\u00020\u0006*\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/soywiz/krypto/PBKDF2$Companion;", "", "()V", "pbkdf2", "Lcom/soywiz/krypto/Hash;", "password", "", "salt", "iterationCount", "", "keySizeInBits", "hasher", "Lcom/soywiz/krypto/Hasher;", "pbkdf2WithHmacSHA1", "pbkdf2WithHmacSHA256", "pbkdf2WithHmacSHA512", "toByteArray", "out", "krypto_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash pbkdf2WithHmacSHA1(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits) {
            return this.pbkdf2(password, salt, iterationCount, keySizeInBits, new SHA1());
        }

        @NotNull
        public final Hash pbkdf2WithHmacSHA256(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits) {
            return this.pbkdf2(password, salt, iterationCount, keySizeInBits, new SHA256());
        }

        @NotNull
        public final Hash pbkdf2WithHmacSHA512(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits) {
            return this.pbkdf2(password, salt, iterationCount, keySizeInBits, new SHA512());
        }

        private final byte[] toByteArray(int $this$toByteArray, byte[] out) {
            out[0] = (byte)($this$toByteArray >> 24 & 0xFF);
            out[1] = (byte)($this$toByteArray >> 16 & 0xFF);
            out[2] = (byte)($this$toByteArray >> 8 & 0xFF);
            out[3] = (byte)($this$toByteArray & 0xFF);
            return out;
        }

        static /* synthetic */ byte[] toByteArray$default(Companion companion, int n, byte[] byArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byArray = new byte[4];
            }
            return companion.toByteArray(n, byArray);
        }

        @NotNull
        public final Hash pbkdf2(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits, @NotNull Hasher hasher) {
            int hLen = hasher.getDigestSize();
            int blockSize = keySizeInBits / hLen;
            int outSize = keySizeInBits / 8;
            int offset = 0;
            byte[] result = new byte[outSize];
            byte[] t = new byte[hLen];
            byte[] i32be = new byte[4];
            byte[] uv = new byte[salt.length + i32be.length];
            int i = 1;
            if (i <= blockSize) {
                block0: while (true) {
                    ArraysKt.fill$default((byte[])t, (byte)0, (int)0, (int)0, (int)6, null);
                    this.toByteArray(i, i32be);
                    KryptoToolsKt.arraycopy(salt, 0, uv, 0, salt.length);
                    KryptoToolsKt.arraycopy(i32be, 0, uv, salt.length, i32be.length);
                    byte[] u = uv;
                    int c = 1;
                    if (c <= iterationCount) {
                        while (true) {
                            u = HMAC.Companion.hmac$krypto_release(password, u, hasher).getBytes();
                            hasher.reset();
                            int n = u.length;
                            for (int m = 0; m < n; ++m) {
                                t[m] = (byte)(t[m] ^ u[m]);
                            }
                            if (c == iterationCount) break;
                            ++c;
                        }
                    }
                    int n = t.length;
                    for (int j = 0; j < n; ++j) {
                        byte b = t[j];
                        result[offset++] = b;
                        if (offset >= outSize) break block0;
                    }
                    if (i == blockSize) break;
                    ++i;
                }
            }
            return new Hash(result);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

