/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/soywiz/krypto/PRNGFixes;", "", "()V", "BUILD_FINGERPRINT_AND_DEVICE_SERIAL", "", "VERSION_CODE_JELLY_BEAN", "", "VERSION_CODE_JELLY_BEAN_MR2", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "apply", "", "applyOpenSSLFix", "generateSeed", "installLinuxPRNGSecureRandom", "LinuxPRNGSecureRandom", "LinuxPRNGSecureRandomProvider", "krypto_release"})
public final class PRNGFixes {
    @NotNull
    public static final PRNGFixes INSTANCE;
    private static final int VERSION_CODE_JELLY_BEAN = 16;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    @NotNull
    private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL;

    private PRNGFixes() {
    }

    private final String getDeviceSerialNumber() {
        String string;
        try {
            Object object = Build.class.getField("SERIAL").get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        catch (Exception ignored) {
            string = null;
        }
        return string;
    }

    public final void apply() {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        boolean notMockedUnittests = Result.isSuccess-impl((Object)object);
        if (notMockedUnittests) {
            this.applyOpenSSLFix();
            this.installLinuxPRNGSecureRandom();
        }
    }

    private final void applyOpenSSLFix() throws SecurityException {
        if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
            return;
        }
        try {
            Object[] objectArray = new Class[]{byte[].class};
            Method method = Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", (Class<?>[])objectArray);
            objectArray = new Object[]{this.generateSeed()};
            method.invoke(null, objectArray);
            Object[] objectArray2 = new Class[]{String.class, Long.TYPE};
            Method method2 = Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", (Class<?>[])objectArray2);
            objectArray2 = new Object[]{"/dev/urandom", 1024};
            Object object = method2.invoke(null, objectArray2);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int bytesRead = (Integer)object;
            if (bytesRead != 1024) {
                throw new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
            }
        }
        catch (Exception e) {
            throw new SecurityException("Failed to seed OpenSSL PRNG", e);
        }
    }

    private final void installLinuxPRNGSecureRandom() throws SecurityException {
        SecureRandom rng1;
        if (Build.VERSION.SDK_INT > 18) {
            return;
        }
        Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
        if (secureRandomProviders == null || secureRandomProviders.length == 0 || !Intrinsics.areEqual(LinuxPRNGSecureRandomProvider.class, secureRandomProviders[0].getClass())) {
            Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
        }
        if (!Intrinsics.areEqual(LinuxPRNGSecureRandomProvider.class, (rng1 = new SecureRandom()).getProvider().getClass())) {
            throw new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
        }
        SecureRandom rng2 = null;
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            Intrinsics.checkNotNullExpressionValue((Object)secureRandom, (String)"getInstance(\"SHA1PRNG\")");
            rng2 = secureRandom;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("SHA1PRNG not available", e);
        }
        if (!Intrinsics.areEqual(LinuxPRNGSecureRandomProvider.class, rng2.getProvider().getClass())) {
            throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
        }
    }

    private final byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
            seedBufferOut.close();
            byte[] byArray = seedBuffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"seedBuffer.toByteArray()");
            return byArray;
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    static {
        Object object;
        String serial;
        PRNGFixes $this$BUILD_FINGERPRINT_AND_DEVICE_SERIAL_u24lambda_u2d0 = INSTANCE = new PRNGFixes();
        boolean bl = false;
        StringBuilder result = new StringBuilder();
        String fingerprint = Build.FINGERPRINT;
        if (fingerprint != null) {
            result.append(fingerprint);
        }
        if ((serial = $this$BUILD_FINGERPRINT_AND_DEVICE_SERIAL_u24lambda_u2d0.getDeviceSerialNumber()) != null) {
            result.append(serial);
        }
        try {
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            object = string;
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            Charset charset2 = charset;
            byte[] byArray = ((String)object).getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
        BUILD_FINGERPRINT_AND_DEVICE_SERIAL = (byte[])object;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/soywiz/krypto/PRNGFixes$LinuxPRNGSecureRandomProvider;", "Ljava/security/Provider;", "()V", "krypto_release"})
    private static final class LinuxPRNGSecureRandomProvider
    extends Provider {
        public LinuxPRNGSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/soywiz/krypto/PRNGFixes$LinuxPRNGSecureRandom;", "Ljava/security/SecureRandomSpi;", "()V", "mSeeded", "", "urandomInputStream", "Ljava/io/DataInputStream;", "getUrandomInputStream", "()Ljava/io/DataInputStream;", "urandomOutputStream", "Ljava/io/OutputStream;", "getUrandomOutputStream", "()Ljava/io/OutputStream;", "engineGenerateSeed", "", "size", "", "engineNextBytes", "", "bytes", "engineSetSeed", "Companion", "krypto_release"})
    public static final class LinuxPRNGSecureRandom
    extends SecureRandomSpi {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean mSeeded;
        @NotNull
        private static final File URANDOM_FILE = new File("/dev/urandom");
        @NotNull
        private static final Object sLock = new Object();
        @Nullable
        private static DataInputStream sUrandomIn;
        @Nullable
        private static OutputStream sUrandomOut;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final DataInputStream getUrandomInputStream() {
            Object object = sLock;
            synchronized (object) {
                boolean bl = false;
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException e) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                    }
                }
                DataInputStream dataInputStream = sUrandomIn;
                Intrinsics.checkNotNull((Object)dataInputStream);
                DataInputStream dataInputStream2 = dataInputStream;
                return dataInputStream2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final OutputStream getUrandomOutputStream() throws IOException {
            Object object = sLock;
            synchronized (object) {
                boolean bl = false;
                if (sUrandomOut == null) {
                    sUrandomOut = new FileOutputStream(URANDOM_FILE);
                }
                OutputStream outputStream = sUrandomOut;
                Intrinsics.checkNotNull((Object)outputStream);
                OutputStream outputStream2 = outputStream;
                return outputStream2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(@NotNull byte[] bytes) {
            try {
                OutputStream out = null;
                Object object = sLock;
                synchronized (object) {
                    boolean bl = false;
                    out = this.getUrandomOutputStream();
                    Unit unit = Unit.INSTANCE;
                }
                out.write(bytes);
                out.flush();
            }
            catch (IOException e) {
                Log.w((String)PRNGFixes.class.getSimpleName(), (String)("Failed to mix seed into " + URANDOM_FILE));
            }
            finally {
                this.mSeeded = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(@NotNull byte[] bytes) {
            if (!this.mSeeded) {
                this.engineSetSeed(INSTANCE.generateSeed());
            }
            try {
                DataInputStream in = null;
                Object object = sLock;
                synchronized (object) {
                    boolean $i$a$-synchronized-PRNGFixes$LinuxPRNGSecureRandom$engineNextBytes$32 = false;
                    in = this.getUrandomInputStream();
                    Unit $i$a$-synchronized-PRNGFixes$LinuxPRNGSecureRandom$engineNextBytes$32 = Unit.INSTANCE;
                }
                object = in;
                synchronized (object) {
                    boolean bl = false;
                    in.readFully(bytes);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, e);
            }
        }

        @Override
        @NotNull
        protected byte[] engineGenerateSeed(int size) {
            byte[] seed = new byte[size];
            this.engineNextBytes(seed);
            return seed;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/soywiz/krypto/PRNGFixes$LinuxPRNGSecureRandom$Companion;", "", "()V", "URANDOM_FILE", "Ljava/io/File;", "sLock", "sUrandomIn", "Ljava/io/DataInputStream;", "sUrandomOut", "Ljava/io/OutputStream;", "krypto_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

