/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.HMAC;
import com.soywiz.krypto.Hasher;
import com.soywiz.krypto.SHA1;
import com.soywiz.krypto.SHA256;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/soywiz/krypto/PBKDF2;", "", "()V", "Companion", "krypto"})
public final class PBKDF2 {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\f\u0010\u000e\u001a\u00020\u0004*\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/soywiz/krypto/PBKDF2$Companion;", "", "()V", "pbkdf2", "", "password", "salt", "iterationCount", "", "keySizeInBits", "hasher", "Lcom/soywiz/krypto/Hasher;", "pbkdf2WithHmacSHA1", "pbkdf2WithHmacSHA256", "toByteArray", "krypto"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] pbkdf2WithHmacSHA1(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            return this.pbkdf2(password, salt, iterationCount, keySizeInBits, new SHA1());
        }

        @NotNull
        public final byte[] pbkdf2WithHmacSHA256(@NotNull byte[] password, @NotNull byte[] salt, int iterationCount, int keySizeInBits) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            return this.pbkdf2(password, salt, iterationCount, keySizeInBits, new SHA256());
        }

        private final byte[] toByteArray(int $this$toByteArray) {
            byte[] byArray = new byte[]{(byte)($this$toByteArray >> 24 & 0xFF), (byte)($this$toByteArray >> 16 & 0xFF), (byte)($this$toByteArray >> 8 & 0xFF), (byte)($this$toByteArray & 0xFF)};
            return byArray;
        }

        private final byte[] pbkdf2(byte[] password, byte[] salt, int iterationCount, int keySizeInBits, Hasher hasher) {
            int hLen = hasher.getDigestSize();
            int blockSize = keySizeInBits / hLen;
            int outSize = keySizeInBits / 8;
            byte[] result = new byte[outSize];
            int offset = 0;
            byte[] t = new byte[hLen];
            int n = 1;
            if (n <= blockSize) {
                int i;
                block0: do {
                    i = n++;
                    ArraysKt.fill$default((byte[])t, (byte)0, (int)0, (int)0, (int)6, null);
                    byte[] i32be = this.toByteArray(i);
                    byte[] u = new byte[salt.length + i32be.length];
                    KryptoToolsKt.arraycopy(salt, 0, u, 0, salt.length);
                    KryptoToolsKt.arraycopy(i32be, 0, u, salt.length, i32be.length);
                    int n2 = 1;
                    if (n2 <= iterationCount) {
                        int c;
                        do {
                            c = n2++;
                            u = HMAC.Companion.hmac-ldaWLbI$krypto(password, u, hasher);
                            hasher.reset();
                            int n3 = 0;
                            int n4 = u.length + -1;
                            if (n3 > n4) continue;
                            do {
                                int m = n3++;
                                t[m] = (byte)(t[m] ^ u[m]);
                            } while (n3 <= n4);
                        } while (c != iterationCount);
                    }
                    for (byte b : t) {
                        int n5 = offset;
                        offset = n5 + 1;
                        result[n5] = b;
                        if (offset < outSize) continue;
                        break block0;
                    }
                } while (i != blockSize);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

