/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto;

import com.soywiz.krypto.Hasher;
import com.soywiz.krypto.HasherFactory;
import com.soywiz.krypto.SHA;
import com.soywiz.krypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/soywiz/krypto/SHA256;", "Lcom/soywiz/krypto/SHA;", "()V", "h", "", "r", "w", "coreDigest", "", "out", "", "coreReset", "coreUpdate", "chunk", "Companion", "krypto"})
public final class SHA256
extends SHA {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] h = new int[8];
    @NotNull
    private final int[] r = new int[8];
    @NotNull
    private final int[] w = new int[64];
    @NotNull
    private static final int[] H;
    @NotNull
    private static final int[] K;

    public SHA256() {
        super(64, 32);
        this.coreReset();
    }

    @Override
    protected void coreReset() {
        SHA256 sHA256 = this;
        boolean bl = false;
        boolean bl2 = false;
        SHA256 $this$coreReset_u24lambda_u2d0 = sHA256;
        boolean bl3 = false;
        KryptoToolsKt.arraycopy(H, 0, $this$coreReset_u24lambda_u2d0.h, 0, 8);
    }

    @Override
    protected void coreUpdate(@NotNull byte[] chunk) {
        int j;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        KryptoToolsKt.arraycopy(this.h, 0, this.r, 0, 8);
        int n = 0;
        do {
            j = n++;
            this.w[j] = KryptoToolsKt.readS32_be(chunk, j * 4);
        } while (n < 16);
        n = 16;
        do {
            j = n++;
            int s0 = KryptoToolsKt.rotateRight(this.w[j - 15], 7) ^ KryptoToolsKt.rotateRight(this.w[j - 15], 18) ^ this.w[j - 15] >>> 3;
            int s1 = KryptoToolsKt.rotateRight(this.w[j - 2], 17) ^ KryptoToolsKt.rotateRight(this.w[j - 2], 19) ^ this.w[j - 2] >>> 10;
            this.w[j] = this.w[j - 16] + s0 + this.w[j - 7] + s1;
        } while (n < 64);
        n = 0;
        do {
            j = n++;
            int s1 = KryptoToolsKt.rotateRight(this.r[4], 6) ^ KryptoToolsKt.rotateRight(this.r[4], 11) ^ KryptoToolsKt.rotateRight(this.r[4], 25);
            int ch = this.r[4] & this.r[5] ^ ~this.r[4] & this.r[6];
            int t1 = this.r[7] + s1 + ch + K[j] + this.w[j];
            int s0 = KryptoToolsKt.rotateRight(this.r[0], 2) ^ KryptoToolsKt.rotateRight(this.r[0], 13) ^ KryptoToolsKt.rotateRight(this.r[0], 22);
            int maj = this.r[0] & this.r[1] ^ this.r[0] & this.r[2] ^ this.r[1] & this.r[2];
            int t2 = s0 + maj;
            this.r[7] = this.r[6];
            this.r[6] = this.r[5];
            this.r[5] = this.r[4];
            this.r[4] = this.r[3] + t1;
            this.r[3] = this.r[2];
            this.r[2] = this.r[1];
            this.r[1] = this.r[0];
            this.r[0] = t1 + t2;
        } while (n < 64);
        n = 0;
        do {
            j = n++;
            int[] nArray = this.h;
            int n2 = j;
            nArray[n2] = nArray[n2] + this.r[j];
        } while (n < 8);
    }

    @Override
    protected void coreDigest(@NotNull byte[] out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = 0;
        int n2 = out.length + -1;
        if (n <= n2) {
            do {
                int n3 = n++;
                out[n3] = (byte)(this.h[n3 / 4] >>> 24 - 8 * (n3 % 4));
            } while (n <= n2);
        }
    }

    static {
        int[] nArray = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
        H = nArray;
        nArray = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
        K = nArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/soywiz/krypto/SHA256$Companion;", "Lcom/soywiz/krypto/HasherFactory;", "()V", "H", "", "K", "krypto"})
    public static final class Companion
    extends HasherFactory {
        private Companion() {
            super((Function0<? extends Hasher>)((Function0)1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

