/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.krypto.encoding;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0011\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\nH\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006H\u0086\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0014\u0010\u0013\u001a\u00020\b*\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/soywiz/krypto/encoding/Base64;", "", "()V", "DECODE", "", "TABLE", "", "decode", "", "src", "", "dst", "str", "decodeIgnoringSpaces", "encode", "invoke", "v", "readU24BE", "index", "readU8", "krypto"})
public final class Base64 {
    @NotNull
    public static final Base64 INSTANCE = new Base64();
    @NotNull
    private static final String TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    @NotNull
    private static final int[] DECODE;

    private Base64() {
    }

    @NotNull
    public final byte[] invoke(@NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.decodeIgnoringSpaces(v);
    }

    @NotNull
    public final String invoke(@NotNull byte[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.encode(v);
    }

    @NotNull
    public final byte[] decode(@NotNull String str) {
        byte[] dst;
        int n;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int n2 = 0;
        int n3 = str.length();
        byte[] byArray = new byte[n3];
        while (n2 < n3) {
            n = n2++;
            byArray[n] = (byte)str.charAt(n);
        }
        byte[] src = byArray;
        byte[] byArray2 = dst = new byte[src.length];
        int n4 = this.decode(src, dst);
        n = 0;
        byte[] byArray3 = Arrays.copyOf(byArray2, n4);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        return byArray3;
    }

    @NotNull
    public final byte[] decodeIgnoringSpaces(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.decode(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null));
    }

    public final int decode(@NotNull byte[] src, @NotNull byte[] dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int m = 0;
        int n = 0;
        while (n < src.length) {
            int n2;
            int n3;
            int b2;
            int n4;
            int b1;
            int n5;
            int b0;
            int n6;
            int d = DECODE[this.readU8(src, n)];
            if (d < 0) {
                int n7 = n;
                n = n7 + 1;
                continue;
            }
            if (n < src.length) {
                int n8 = n;
                n = n8 + 1;
                n6 = DECODE[this.readU8(src, n8)];
            } else {
                n6 = b0 = 64;
            }
            if (n < src.length) {
                int n9 = n;
                n = n9 + 1;
                n5 = DECODE[this.readU8(src, n9)];
            } else {
                n5 = b1 = 64;
            }
            if (n < src.length) {
                int n10 = n;
                n = n10 + 1;
                n4 = DECODE[this.readU8(src, n10)];
            } else {
                n4 = b2 = 64;
            }
            if (n < src.length) {
                n3 = n;
                n = n3 + 1;
                n2 = DECODE[this.readU8(src, n3)];
            } else {
                n2 = 64;
            }
            int b3 = n2;
            n3 = m;
            m = n3 + 1;
            dst[n3] = (byte)(b0 << 2 | b1 >> 4);
            if (b2 >= 64) continue;
            n3 = m;
            m = n3 + 1;
            dst[n3] = (byte)(b1 << 4 | b2 >> 2);
            if (b3 >= 64) continue;
            n3 = m;
            m = n3 + 1;
            dst[n3] = (byte)(b2 << 6 | b3);
        }
        return m;
    }

    @NotNull
    public final String encode(@NotNull byte[] src) {
        int num;
        int ipos;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        StringBuilder out = new StringBuilder(src.length * 4 / 3 + 4);
        int extraBytes = src.length % 3;
        for (ipos = 0; ipos < src.length - 2; ipos += 3) {
            num = this.readU24BE(src, ipos);
            out.append(TABLE.charAt(num >>> 18 & 0x3F));
            out.append(TABLE.charAt(num >>> 12 & 0x3F));
            out.append(TABLE.charAt(num >>> 6 & 0x3F));
            out.append(TABLE.charAt(num >>> 0 & 0x3F));
        }
        switch (extraBytes) {
            case 1: {
                int n = ipos;
                ipos = n + 1;
                num = this.readU8(src, n);
                out.append(TABLE.charAt(num >>> 2));
                out.append(TABLE.charAt(num << 4 & 0x3F));
                out.append('=');
                out.append('=');
                break;
            }
            case 2: {
                int n = ipos;
                ipos = n + 1;
                int n2 = this.readU8(src, n) << 8;
                n = ipos;
                ipos = n + 1;
                int tmp = n2 | this.readU8(src, n);
                out.append(TABLE.charAt(tmp >>> 10));
                out.append(TABLE.charAt(tmp >>> 4 & 0x3F));
                out.append(TABLE.charAt(tmp << 2 & 0x3F));
                out.append('=');
            }
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    private final int readU8(byte[] $this$readU8, int index) {
        return $this$readU8[index] & 0xFF;
    }

    private final int readU24BE(byte[] $this$readU24BE, int index) {
        return this.readU8($this$readU24BE, index + 0) << 16 | this.readU8($this$readU24BE, index + 1) << 8 | this.readU8($this$readU24BE, index + 2) << 0;
    }

    static {
        int[] nArray = new int[256];
        boolean bl = false;
        boolean bl2 = false;
        int[] $this$DECODE_u24lambda_u2d0 = nArray;
        boolean bl3 = false;
        int n = 0;
        do {
            int n2 = n++;
            $this$DECODE_u24lambda_u2d0[n2] = -1;
        } while (n <= 255);
        n = 0;
        int n3 = TABLE.length();
        if (n < n3) {
            do {
                int n4;
                $this$DECODE_u24lambda_u2d0[Base64.TABLE.charAt((int)n4)] = n4 = n++;
            } while (n < n3);
        }
        DECODE = nArray;
    }
}

