/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.Arrays;
import korlibs.crypto.encoding.Base64;
import korlibs.crypto.encoding.Hex;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001a"}, d2={"Lkorlibs/crypto/Hash;", "", "bytes", "", "([B)V", "base64", "", "getBase64", "()Ljava/lang/String;", "base64Url", "getBase64Url", "getBytes", "()[B", "hex", "getHex", "hexLower", "getHexLower", "hexUpper", "getHexUpper", "equals", "", "other", "hashCode", "", "toString", "Companion", "krypto"})
public final class Hash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;

    public Hash(@NotNull byte[] bytes) {
        this.bytes = bytes;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @NotNull
    public final String getBase64() {
        return Base64.encode$default(Base64.INSTANCE, this.bytes, false, false, 6, null);
    }

    @NotNull
    public final String getBase64Url() {
        return Base64.encode$default(Base64.INSTANCE, this.bytes, true, false, 4, null);
    }

    @NotNull
    public final String getHex() {
        return Hex.INSTANCE.encode(this.bytes);
    }

    @NotNull
    public final String getHexLower() {
        return Hex.INSTANCE.encodeLower(this.bytes);
    }

    @NotNull
    public final String getHexUpper() {
        return Hex.INSTANCE.encodeUpper(this.bytes);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Hash && Arrays.equals(this.bytes, ((Hash)other).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @NotNull
    public String toString() {
        return this.getHexLower();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lkorlibs/crypto/Hash$Companion;", "", "()V", "fromBase64", "Lkorlibs/crypto/Hash;", "base64", "", "fromHex", "hex", "krypto"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash fromHex(@NotNull String hex) {
            return new Hash(Hex.decode$default(Hex.INSTANCE, hex, null, 2, null));
        }

        @NotNull
        public final Hash fromBase64(@NotNull String base64) {
            return new Hash(Base64.decodeIgnoringSpaces$default(Base64.INSTANCE, base64, false, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

