/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost;

import com.sparkpost.exception.SparkPostException;
import com.sparkpost.model.AddressAttributes;
import com.sparkpost.model.RecipientAttributes;
import com.sparkpost.model.TemplateContentAttributes;
import com.sparkpost.model.TransmissionWithRecipientArray;
import com.sparkpost.model.responses.Response;
import com.sparkpost.model.responses.TransmissionCreateResponse;
import com.sparkpost.resources.ResourceTransmissions;
import com.sparkpost.transport.RestConnection;
import java.util.ArrayList;
import java.util.List;

public class Client {
    private String authKey;
    private String username;
    private String password;
    private String fromEmail;

    public Client() {
    }

    public Client(String key) {
        this.setAuthKey(key);
    }

    public final void setAuthKey(String key) {
        this.authKey = key;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public Response sendMessage(String from, String recipient, String subject, String text, String html) throws SparkPostException {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        return this.sendMessage(from, recipients, subject, text, html);
    }

    public Response sendMessage(String from, List<String> recipients, String subject, String text, String html) throws SparkPostException {
        TransmissionWithRecipientArray transmission = new TransmissionWithRecipientArray();
        ArrayList<RecipientAttributes> recipientArray = new ArrayList<RecipientAttributes>();
        for (String recpient : recipients) {
            RecipientAttributes recipientAttribs = new RecipientAttributes();
            recipientAttribs.setAddress(new AddressAttributes(recpient));
            recipientArray.add(recipientAttribs);
        }
        transmission.setRecipientArray(recipientArray);
        TemplateContentAttributes contentAttributes = new TemplateContentAttributes();
        contentAttributes.setFrom(new AddressAttributes(from));
        contentAttributes.setSubject(subject);
        contentAttributes.setHtml(html);
        contentAttributes.setText(text);
        transmission.setContentAttributes(contentAttributes);
        RestConnection connection = new RestConnection(this);
        TransmissionCreateResponse response = ResourceTransmissions.create(connection, 0, transmission);
        return response;
    }

    public String toString() {
        return "client[email: " + this.fromEmail;
    }
}

