/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;

public class SuppressionListEntry
extends Base {
    @Description(value="Email Address", sample={"address@example.com"})
    private String email;
    @Description(value="Whether the recipient requested to not receive any transactional messages. At a minimum, transactional or non_transactional is required upon creation of the entry.", sample={"true"})
    private boolean transactional;
    @Description(value="Whether the recipient requested to not receive any non-transactional messages. At a minimum, transactional or non_transactional is required upon creation of the entry.", sample={"false"})
    @SerializedName(value="non_transactional")
    private boolean nonTransactional;
    @Description(value="Source responsible for inserting the list entry. Valid values include: FBL, List Unsubscribe, Bounce Rule, Unsubscribe Link, Manually Added, Compliance. Defaults to Manually Added on create", sample={"Manually Added"})
    private String source = "Manually Added";
    @Description(value="Short explanation of the suppression", sample={""})
    private String description;

    public SuppressionListEntry() {
    }

    public SuppressionListEntry(SuppressionListEntry entry) {
        this.email = entry.email;
        this.transactional = entry.transactional;
        this.nonTransactional = entry.nonTransactional;
        this.source = entry.source;
        this.description = entry.description;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean isNonTransactional() {
        return this.nonTransactional;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setNonTransactional(boolean nonTransactional) {
        this.nonTransactional = nonTransactional;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "SuppressionListEntry(email=" + this.getEmail() + ", transactional=" + this.isTransactional() + ", nonTransactional=" + this.isNonTransactional() + ", source=" + this.getSource() + ", description=" + this.getDescription() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuppressionListEntry)) {
            return false;
        }
        SuppressionListEntry other = (SuppressionListEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        if (this.isTransactional() != other.isTransactional()) {
            return false;
        }
        if (this.isNonTransactional() != other.isNonTransactional()) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuppressionListEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        result = result * 59 + (this.isTransactional() ? 79 : 97);
        result = result * 59 + (this.isNonTransactional() ? 79 : 97);
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class StatusTypes {
        public static final String FBL = "FBL";
        public static final String LIST_UNSUBSCRIBE = "List Unsubscribe";
        public static final String BOUNCE_RULE = "Bounce Rule";
        public static final String UNSUBSCRIBE_LINK = "Unsubscribe Link";
        public static final String MANUALLY_ADDED = "Manually Added";
        public static final String COMPLIANCE = "Compliance";
    }
}

