/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.sparkpost.model.OptionsAttributes;
import com.sparkpost.model.TemplateContentAttributes;
import com.yepher.jsondoc.annotations.Description;
import java.util.Map;

public class TransmissionBase
extends Base {
    @Description(value="ID of the transmission. A unique ID is generated for each transmission on submission.", sample={"AbC123"})
    private String id = null;
    @Description(value="State of the transmission. Valid responses are \"submitted\", \"Generating\", \"Success\", or \"Canceled\".", sample={"Generating"})
    private String state = null;
    @Description(value="Object in which transmission options are defined. For a full description, see the Options Attributes.", sample={"OptionsAttributes Object"})
    private OptionsAttributes options = null;
    @Description(value="Name of the campaign. Maximum length - 64 bytes", sample={"AbC123"})
    @SerializedName(value="campaign_id")
    private String campaignId = null;
    @Description(value="Description of the transmission. Maximum length - 1024 bytes", sample={""})
    private String description = null;
    @Description(value="Transmission level metadata containing key/value pairs. Metadata is available during events through the Webhooks and is provided to the substitution engine. A maximum of 1000 bytes of merged metadata (transmission level + recipient level) is available with recipient metadata taking precedence over transmission metadata when there are conflicts.", sample={""})
    private Map<String, String> metadata = null;
    @Description(value="Key/value pairs that are provided to the substitution engine. Recipient substitution data takes precedence over transmission substitution data. Unlike metadata, substitution data is not included in Webhook events.", sample={""})
    @SerializedName(value="substitution_data")
    private Map<String, Object> substitutionData = null;
    @Description(value="Email to use for envelope FROM ( Note: SparkPost Elite only )", sample={"return_name@example.com"})
    @SerializedName(value="return_path")
    private String returnPath = null;
    @Description(value="Content that will be used to construct a message. Maximum size - 15MBs", sample={""})
    @SerializedName(value="content")
    private TemplateContentAttributes contentAttributes = null;
    @Description(value="Computed total recipients", sample={"1000"})
    @SerializedName(value="total_recipients")
    private Integer totalRecipients = null;
    @Description(value="Computed total number of messages generated", sample={"1000"})
    @SerializedName(value="num_generated")
    private Integer numGenerated = null;
    @Description(value="Computed total number of failed messages", sample={"0"})
    @SerializedName(value="num_failed_generation")
    private Integer numFailedGeneration = null;
    @Description(value="Number of recipients that failed input validation", sample={"0"})
    @SerializedName(value="num_invalid_recipients")
    private Integer numInvalidRecipients = null;

    public String getId() {
        return this.id;
    }

    public String getState() {
        return this.state;
    }

    public OptionsAttributes getOptions() {
        return this.options;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getSubstitutionData() {
        return this.substitutionData;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public TemplateContentAttributes getContentAttributes() {
        return this.contentAttributes;
    }

    public Integer getNumGenerated() {
        return this.numGenerated;
    }

    public Integer getNumFailedGeneration() {
        return this.numFailedGeneration;
    }

    public Integer getNumInvalidRecipients() {
        return this.numInvalidRecipients;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setOptions(OptionsAttributes options) {
        this.options = options;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setSubstitutionData(Map<String, Object> substitutionData) {
        this.substitutionData = substitutionData;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public void setContentAttributes(TemplateContentAttributes contentAttributes) {
        this.contentAttributes = contentAttributes;
    }

    public void setTotalRecipients(Integer totalRecipients) {
        this.totalRecipients = totalRecipients;
    }

    public void setNumGenerated(Integer numGenerated) {
        this.numGenerated = numGenerated;
    }

    public void setNumFailedGeneration(Integer numFailedGeneration) {
        this.numFailedGeneration = numFailedGeneration;
    }

    public void setNumInvalidRecipients(Integer numInvalidRecipients) {
        this.numInvalidRecipients = numInvalidRecipients;
    }

    public String toString() {
        return "TransmissionBase(id=" + this.getId() + ", state=" + this.getState() + ", options=" + this.getOptions() + ", campaignId=" + this.getCampaignId() + ", description=" + this.getDescription() + ", metadata=" + this.getMetadata() + ", substitutionData=" + this.getSubstitutionData() + ", returnPath=" + this.getReturnPath() + ", contentAttributes=" + this.getContentAttributes() + ", totalRecipients=" + this.getTotalRecipients() + ", numGenerated=" + this.getNumGenerated() + ", numFailedGeneration=" + this.getNumFailedGeneration() + ", numInvalidRecipients=" + this.getNumInvalidRecipients() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransmissionBase)) {
            return false;
        }
        TransmissionBase other = (TransmissionBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        OptionsAttributes this$options = this.getOptions();
        OptionsAttributes other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$campaignId = this.getCampaignId();
        String other$campaignId = other.getCampaignId();
        if (this$campaignId == null ? other$campaignId != null : !this$campaignId.equals(other$campaignId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Map<String, Object> this$substitutionData = this.getSubstitutionData();
        Map<String, Object> other$substitutionData = other.getSubstitutionData();
        if (this$substitutionData == null ? other$substitutionData != null : !((Object)this$substitutionData).equals(other$substitutionData)) {
            return false;
        }
        String this$returnPath = this.getReturnPath();
        String other$returnPath = other.getReturnPath();
        if (this$returnPath == null ? other$returnPath != null : !this$returnPath.equals(other$returnPath)) {
            return false;
        }
        TemplateContentAttributes this$contentAttributes = this.getContentAttributes();
        TemplateContentAttributes other$contentAttributes = other.getContentAttributes();
        if (this$contentAttributes == null ? other$contentAttributes != null : !((Object)this$contentAttributes).equals(other$contentAttributes)) {
            return false;
        }
        Integer this$totalRecipients = this.getTotalRecipients();
        Integer other$totalRecipients = other.getTotalRecipients();
        if (this$totalRecipients == null ? other$totalRecipients != null : !((Object)this$totalRecipients).equals(other$totalRecipients)) {
            return false;
        }
        Integer this$numGenerated = this.getNumGenerated();
        Integer other$numGenerated = other.getNumGenerated();
        if (this$numGenerated == null ? other$numGenerated != null : !((Object)this$numGenerated).equals(other$numGenerated)) {
            return false;
        }
        Integer this$numFailedGeneration = this.getNumFailedGeneration();
        Integer other$numFailedGeneration = other.getNumFailedGeneration();
        if (this$numFailedGeneration == null ? other$numFailedGeneration != null : !((Object)this$numFailedGeneration).equals(other$numFailedGeneration)) {
            return false;
        }
        Integer this$numInvalidRecipients = this.getNumInvalidRecipients();
        Integer other$numInvalidRecipients = other.getNumInvalidRecipients();
        return !(this$numInvalidRecipients == null ? other$numInvalidRecipients != null : !((Object)this$numInvalidRecipients).equals(other$numInvalidRecipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransmissionBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        OptionsAttributes $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $campaignId = this.getCampaignId();
        result = result * 59 + ($campaignId == null ? 43 : $campaignId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Map<String, Object> $substitutionData = this.getSubstitutionData();
        result = result * 59 + ($substitutionData == null ? 43 : ((Object)$substitutionData).hashCode());
        String $returnPath = this.getReturnPath();
        result = result * 59 + ($returnPath == null ? 43 : $returnPath.hashCode());
        TemplateContentAttributes $contentAttributes = this.getContentAttributes();
        result = result * 59 + ($contentAttributes == null ? 43 : ((Object)$contentAttributes).hashCode());
        Integer $totalRecipients = this.getTotalRecipients();
        result = result * 59 + ($totalRecipients == null ? 43 : ((Object)$totalRecipients).hashCode());
        Integer $numGenerated = this.getNumGenerated();
        result = result * 59 + ($numGenerated == null ? 43 : ((Object)$numGenerated).hashCode());
        Integer $numFailedGeneration = this.getNumFailedGeneration();
        result = result * 59 + ($numFailedGeneration == null ? 43 : ((Object)$numFailedGeneration).hashCode());
        Integer $numInvalidRecipients = this.getNumInvalidRecipients();
        result = result * 59 + ($numInvalidRecipients == null ? 43 : ((Object)$numInvalidRecipients).hashCode());
        return result;
    }

    public Integer getTotalRecipients() {
        return this.totalRecipients;
    }

    public static final class TransmissionStates {
        public static final String SUBMITTED = "submitted";
        public static final String GREETING = "Generating";
        public static final String SUCCESS = "Success";
        public static final String CANCELED = "Canceled";
    }
}

