/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.resources;

import com.sparkpost.exception.SparkPostException;
import com.sparkpost.model.TransmissionWithRecipientArray;
import com.sparkpost.model.responses.Response;
import com.sparkpost.model.responses.TransmissionCreateResponse;
import com.sparkpost.model.responses.TransmissionListResponse;
import com.sparkpost.model.responses.TransmissionRetrieveResults;
import com.sparkpost.resources.Endpoint;
import com.sparkpost.transport.RestConnection;

public class ResourceTransmissions {
    public static TransmissionCreateResponse create(RestConnection conn, Integer numRcptErrors, TransmissionWithRecipientArray trans) throws SparkPostException {
        Endpoint ep = new Endpoint("transmissions");
        ep.addParam("num_rcpt_errors", numRcptErrors);
        String json = trans.toJson();
        Response response = conn.post(ep.toString(), json);
        TransmissionCreateResponse newResult = (TransmissionCreateResponse)TransmissionCreateResponse.decode(response, TransmissionCreateResponse.class);
        return newResult;
    }

    public static TransmissionRetrieveResults retrieve(RestConnection conn, String id) throws SparkPostException {
        Response response = conn.get("transmissions/" + id);
        TransmissionRetrieveResults newResult = (TransmissionRetrieveResults)TransmissionRetrieveResults.decode(response, TransmissionRetrieveResults.class);
        return newResult;
    }

    public static TransmissionListResponse list(RestConnection conn, String campaignId, String templateId) throws SparkPostException {
        Endpoint ep = new Endpoint("transmissions");
        ep.addParam("campaign_id", campaignId);
        ep.addParam("template_id", templateId);
        Response response = conn.get(ep.toString());
        TransmissionListResponse transmissionResponse = (TransmissionListResponse)TransmissionListResponse.decode(response, TransmissionListResponse.class);
        return transmissionResponse;
    }
}

