/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.transport;

import com.sparkpost.Client;
import com.sparkpost.exception.SparkPostAccessForbiddenException;
import com.sparkpost.exception.SparkPostAuthorizationFailedException;
import com.sparkpost.exception.SparkPostErrorServerResponseException;
import com.sparkpost.exception.SparkPostException;
import com.sparkpost.exception.SparkPostIllegalServerResponseException;
import com.sparkpost.model.responses.Response;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RestConnection {
    private static final Logger logger = Logger.getLogger(RestConnection.class);
    private static final String VERSION = "0.15 (415fca4)";
    private static final Base64 BASE64 = new Base64();
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int SUCCESS_RESPONSE_STATUS_CODE = 200;
    private static final int UNAUTHORIZED_RESPONSE_STATUS_CODE = 401;
    private static final int ACCESS_FORBIDDEN_RESPONSE_STATUS_CODE = 403;
    public static final String defaultApiEndpoint = "https://api.sparkpost.com/api/v1/";
    private final Client client;
    private final String endpoint;

    public RestConnection(Client client) throws SparkPostException {
        this(client, null);
    }

    public RestConnection(Client client, String endpoint) throws SparkPostException {
        this.client = client;
        this.endpoint = StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{endpoint}) ? defaultApiEndpoint : (endpoint.endsWith("/") ? endpoint : endpoint + '/');
    }

    private HttpURLConnection createConnectionObject(String path, Method method) throws SparkPostException {
        HttpURLConnection conn;
        try {
            URL url = new URL(this.endpoint + path);
            conn = (HttpURLConnection)url.openConnection();
            if (StringUtils.isNotEmpty((CharSequence)this.client.getAuthKey())) {
                conn.setRequestProperty("Authorization", this.client.getAuthKey());
            } else if (StringUtils.isNotEmpty((CharSequence)this.client.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.client.getPassword())) {
                String encoding = BASE64.encodeAsString((this.client.getUsername() + ":" + this.client.getPassword()).getBytes(DEFAULT_CHARSET));
                conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            conn.setRequestProperty("User-Agent", "java-sparkpost/0.15 (415fca4)");
            conn.setRequestProperty("Content-Type", "application/json");
            switch (method) {
                case GET: {
                    conn.setRequestMethod("GET");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("GET " + url));
                    }
                    break;
                }
                case POST: {
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("POST " + path));
                    }
                    break;
                }
                case PUT: {
                    conn.setRequestMethod("PUT");
                    conn.setDoOutput(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("PUT " + path));
                    }
                    break;
                }
                case DELETE: {
                    conn.setRequestMethod("DELETE");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("DELETE " + path));
                    }
                    break;
                }
                default: {
                    throw new SparkPostException("Invalid Method");
                }
            }
        }
        catch (MalformedURLException ex) {
            throw new SparkPostException("Invalid path: " + path + ex.toString());
        }
        catch (ProtocolException ex) {
            throw new SparkPostException("Invalid method:" + ex.toString());
        }
        catch (IOException ex) {
            throw new SparkPostException("Error with connection to " + path + ex.toString());
        }
        return conn;
    }

    private void sendData(HttpURLConnection conn, String data) throws SparkPostException {
        byte[] bytes = null;
        try {
            bytes = data.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new SparkPostException(e);
        }
        String lenStr = Integer.toString(bytes.length);
        conn.setRequestProperty("Content-Length", lenStr);
        conn.setRequestProperty("Content-Type", "application/json");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending data (" + lenStr + " bytes): " + data));
        }
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(bytes);
            wr.flush();
        }
        catch (IOException ex) {
            throw new SparkPostException("Error sending request data:" + ex.toString());
        }
    }

    private void sendRequest(HttpURLConnection conn, String data, Response response) throws SparkPostException {
        if (data != null) {
            this.sendData(conn, data);
        }
        try {
            int code = conn.getResponseCode();
            response.setResponseCode(code);
            response.setContentType(conn.getHeaderField("Content-Type"));
            String msg = conn.getResponseMessage();
            response.setResponseMessage(msg);
            if (code == 401) {
                throw new SparkPostAuthorizationFailedException();
            }
            if (code == 403) {
                throw new SparkPostAccessForbiddenException();
            }
        }
        catch (IOException ex) {
            throw new SparkPostException("Connection error:" + ex.toString());
        }
    }

    private Response receiveResponse(HttpURLConnection conn, Response response) throws SparkPostException {
        block34: {
            if (!conn.getContentType().toLowerCase().startsWith("application/json")) {
                throw new SparkPostIllegalServerResponseException("Unexpected content type (" + conn.getContentType() + ") from " + conn.getURL());
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), DEFAULT_CHARSET));){
                String line;
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                if (response.getResponseCode() == 200) {
                    response.setResponseBody(sb.toString());
                    response.setRequestId(conn.getHeaderField("X-SparkPost-Request-Id"));
                    break block34;
                }
                throw new SparkPostErrorServerResponseException(sb.toString(), response.getResponseCode());
            }
            catch (FileNotFoundException ex) {
                response.setResponseBody("");
            }
            catch (IOException ex) {
                String line = "";
                try (BufferedReader rd2 = new BufferedReader(new InputStreamReader(conn.getErrorStream(), DEFAULT_CHARSET));){
                    while ((line = rd2.readLine()) != null) {
                        sb.append(line);
                    }
                    response.setResponseBody(sb.toString());
                    response.setRequestId(conn.getHeaderField("X-SparkPost-Request-Id"));
                    logger.error((Object)("Server Response:\n" + sb.toString() + "\n"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (logger.isDebugEnabled()) {
                    logger.error((Object)("Server Response:" + response));
                }
                throw new SparkPostErrorServerResponseException("Error reading server response: " + ex.toString() + ": " + sb.toString() + "(" + response.getResponseMessage() + ")", response.getResponseCode());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response doHttpMethod(String path, Method method, String data, Response response) throws SparkPostException {
        HttpURLConnection conn = null;
        try {
            response.setRequest(path);
            conn = this.createConnectionObject(path, method);
            this.sendRequest(conn, data, response);
            this.receiveResponse(conn, response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Server Response:" + response));
            }
            Response response2 = response;
            return response2;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public Response get(String path) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(path, Method.GET, null, response);
    }

    public Response post(String path, String json) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(path, Method.POST, json, response);
    }

    public Response put(String path, String json) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(path, Method.PUT, json, response);
    }

    public Response delete(String path) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(path, Method.DELETE, null, response);
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

