package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.yepher.jsondoc.annotations.Description;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class AuthCredentials extends Base {

    @Description(value = "Basic Auth Username. Used for 'basic' authorization flow.")
    private String username;

    @Description(value = "Basic Auth Password. Used for 'basic' authorization flow.")
    private String password;

    @Description(value = "OAuth2 access token generated by SparkPost. Returned in case of 'oauth2' authorization flow.")
    @SerializedName("access_token")
    private String accessToken;

    @Description(value = "The lifetime of the access_token in seconds. Returned in case of 'oauth2' authorization flow.")
    @SerializedName("expires_in")
    private Integer expiresIn;
}
