
package com.sparkpost.model.responses;

import java.lang.reflect.Type;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * The response for the SparkPost server, as returned by @a RestConnection
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class Response extends Base {

    private static final Gson GSON = new Gson();

    @Description(value = "The URI of the request", sample = {""})
    private String request = null;

    @Description(value = "Request Identifier", sample = {""})
    private String requestId = null;

    @Description(value = "HTTP Response Code generated by request", sample = {"200"})
    private int responseCode = -1;

    @Description(value = "The 'Content-Type' returne by the server", sample = {"application/json"})
    private String contentType = null;

    @Description(value = "The HTTP Message generated by request", sample = {"OK"})
    private String responseMessage = null;

    @Description(value = "The json of the response", sample = {""})
    @SerializedName("json")
    private String responseBody = null;

    public static <T extends Response> T decode(Response response, Type typeOfT) {
        T newResponse = null;

        // Make sure this is a JSON response before we try and decode with GSON
        if (response.getContentType() != null && response.getContentType().toLowerCase().startsWith("application/json")) {
            newResponse = GSON.fromJson(response.getResponseBody(), typeOfT);
        } else {
            newResponse = GSON.fromJson("{}", typeOfT);
        }

        if (newResponse != null) {
            newResponse.setRequest(response.request);
            newResponse.setRequestId(response.requestId);
            newResponse.setResponseCode(response.responseCode);
            newResponse.setContentType(response.contentType);
            newResponse.setResponseBody(response.responseBody);
            newResponse.setResponseMessage(response.responseMessage);
        }

        return newResponse;
    }

}
