/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost;

import com.sparkpost.exception.SparkPostException;
import com.sparkpost.model.AddressAttributes;
import com.sparkpost.model.OptionsAttributes;
import com.sparkpost.model.RecipientAttributes;
import com.sparkpost.model.TemplateContentAttributes;
import com.sparkpost.model.TransmissionWithRecipientArray;
import com.sparkpost.model.responses.Response;
import com.sparkpost.model.responses.TransmissionCreateResponse;
import com.sparkpost.resources.ResourceTransmissions;
import com.sparkpost.transport.IRestConnection;
import com.sparkpost.transport.RestConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;

public class Client {
    private String authKey;
    private String username;
    private String password;
    private String fromEmail;
    private Proxy proxy;
    private boolean disconnectAfterRequest = false;
    private int httpConnectTimeout = 0;
    private int httpReadTimeout = 0;
    private String baseUrl = "https://api.sparkpost.com/api/v1";

    public Client() {
    }

    public Client(String key) {
        this.setAuthKey(key);
    }

    public Client(String key, String baseUrl) {
        this.setAuthKey(key);
        this.baseUrl = baseUrl;
    }

    public final void setAuthKey(String key) {
        this.authKey = key;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public boolean isDisconnectAfterRequest() {
        return this.disconnectAfterRequest;
    }

    public void setDisconnectAfterRequest(boolean disconnectAfterRequest) {
        this.disconnectAfterRequest = disconnectAfterRequest;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public void setProxy(String hostname, int port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setHttpConnectTimeout(int timeout) {
        this.httpConnectTimeout = timeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(int httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public Response sendMessage(String from, String recipient, String subject, String text, String html) throws SparkPostException {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        return this.sendMessage(from, recipients, subject, text, html);
    }

    public Response sendMessage(String from, List<String> recipients, String subject, String text, String html) throws SparkPostException {
        TransmissionWithRecipientArray transmission = new TransmissionWithRecipientArray();
        ArrayList<RecipientAttributes> recipientArray = new ArrayList<RecipientAttributes>();
        for (String recipient : recipients) {
            RecipientAttributes recipientAttribs = new RecipientAttributes();
            recipientAttribs.setAddress(new AddressAttributes(recipient));
            recipientArray.add(recipientAttribs);
        }
        transmission.setRecipientArray(recipientArray);
        TemplateContentAttributes contentAttributes = new TemplateContentAttributes();
        contentAttributes.setFrom(new AddressAttributes(from));
        contentAttributes.setSubject(subject);
        contentAttributes.setHtml(html);
        contentAttributes.setText(text);
        transmission.setContentAttributes(contentAttributes);
        if (from.toLowerCase().contains("@sparkpostbox.com")) {
            OptionsAttributes options = new OptionsAttributes();
            options.setSandbox(true);
            transmission.setOptions(options);
        }
        RestConnection connection = new RestConnection(this, this.baseUrl);
        TransmissionCreateResponse response = ResourceTransmissions.create((IRestConnection)connection, (Integer)0, transmission);
        return response;
    }

    public String toString() {
        return "client[email: " + this.fromEmail;
    }
}

