/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.sparkpost.resources.Endpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MessageEventsQueryBuilder {
    private boolean sortOutput = false;
    private Set<BounceClass> bounceClasses = new HashSet<BounceClass>();
    private Set<String> campaignIds = new HashSet<String>();
    private Set<EventType> events = new HashSet<EventType>();
    private Set<String> friendlyFroms = new HashSet<String>();
    private String fromDateTime;
    private String toDateTime;
    private Set<String> messageIds = new HashSet<String>();
    private String reason;
    private Set<String> recipients = new HashSet<String>();
    private Set<String> subaccounts = new HashSet<String>();
    private Set<String> templateIds = new HashSet<String>();
    private String timezone;
    private Set<String> transmissionIds = new HashSet<String>();

    public void addBounceClass(BounceClass bounceClass) {
        this.bounceClasses.add(bounceClass);
    }

    public void addCampaignId(String cid) {
        this.campaignIds.add(cid);
    }

    public void addEventType(EventType type) {
        this.events.add(type);
    }

    public void addFriendlyFrom(String from) {
        this.friendlyFroms.add(from);
    }

    public void setFromDateTime(String dateTime) {
        this.fromDateTime = dateTime;
    }

    public void setToDateTime(String dateTime) {
        this.toDateTime = dateTime;
    }

    public void addMessageId(String messageId) {
        this.messageIds.add(messageId);
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void addRecipient(String recipient) {
        this.recipients.add(recipient);
    }

    public void addSubAccount(String subaccount) {
        this.subaccounts.add(subaccount);
    }

    public void addTemplateId(String tid) {
        this.templateIds.add(tid);
    }

    public void setTimezone(String timeZone) {
        this.timezone = timeZone;
    }

    public void addTransmissionId(String tid) {
        this.transmissionIds.add(tid);
    }

    public void buildQuery(Endpoint endpoint) {
        if (this.bounceClasses.size() > 0) {
            endpoint.addParam("bounce_classes", this.setAsString(this.bounceClasses, ","));
        }
        if (this.campaignIds.size() > 0) {
            endpoint.addParam("campaign_ids", this.setAsString(this.campaignIds, ","));
        }
        if (this.events.size() > 0) {
            endpoint.addParam("events", this.setAsString(this.events, ","));
        }
        if (this.friendlyFroms.size() > 0) {
            endpoint.addParam("friendly_froms", this.setAsString(this.friendlyFroms, ","));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fromDateTime)) {
            endpoint.addParam("from", this.fromDateTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.toDateTime)) {
            endpoint.addParam("to", this.toDateTime);
        }
        if (this.messageIds.size() > 0) {
            endpoint.addParam("message_ids", this.setAsString(this.messageIds, ","));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.reason)) {
            endpoint.addParam("reason", this.reason);
        }
        if (this.recipients.size() > 0) {
            endpoint.addParam("recipients", this.setAsString(this.recipients, ","));
        }
        if (this.subaccounts.size() > 0) {
            endpoint.addParam("subaccounts", this.setAsString(this.subaccounts, ","));
        }
        if (this.templateIds.size() > 0) {
            endpoint.addParam("template_ids", this.setAsString(this.templateIds, ","));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.timezone)) {
            endpoint.addParam("timezone", this.timezone);
        }
        if (this.transmissionIds.size() > 0) {
            endpoint.addParam("transmission_ids", this.setAsString(this.transmissionIds, ","));
        }
    }

    public void setSortOutput(boolean sortOutput) {
        this.sortOutput = sortOutput;
    }

    private String setAsString(Set set, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : set) {
            list.add(Objects.toString(obj));
        }
        if (this.sortOutput) {
            Collections.sort(list);
        }
        StringBuilder result = new StringBuilder();
        boolean isFirstElement = true;
        for (String val : list) {
            if (!isFirstElement) {
                result.append(separator);
            }
            result.append(val);
            isFirstElement = false;
        }
        return result.toString();
    }

    public static enum EventType {
        DELIVERY("delivery"),
        INJECTION("injection"),
        BOUNCE_DELAY("bounce,delay"),
        POLICY_REJECTION("policy_rejection"),
        OUT_OF_BAND("out_of_band"),
        OPEN_CLICK("open,click"),
        GENERATION_FAILURE("generation_failure"),
        GENERATION_REJECTION("generation_rejection"),
        SPAM_COMPLAINT("spam_complaint"),
        LIST_UNSUBSCRIBE("list_unsubscribe"),
        LINK_UNSUBSCRIBE("link_unsubscribe");

        private final String eventType;

        private EventType(String eventType) {
            this.eventType = eventType;
        }

        public String eventType() {
            return this.eventType;
        }

        public String toString() {
            return this.eventType;
        }
    }

    public static enum BounceClass {
        UNDERTERMINED(1, "Undetermined", "The response text could not be identified.", "Undetermined"),
        INVALID_RECIPIENT(10, "Invalid Recipient", "The recipient is invalid.", "Hard"),
        SOFT_BOUNCE(20, "Soft Bounce", "The message soft bounced.", "Soft"),
        DNS_FAILURE(21, "DNS Failure", "The message bounced due to a DNS failure.", "Soft"),
        MAILBOX_FULL(22, "Mailbox Full", "The message bounced due to the remote mailbox being over quota.", "Soft"),
        TOO_LARGE(23, "Too Large", "The message bounced because it was too large for the recipient.", "Soft"),
        TIMEOUT(24, "Timeout", "The message timed out.", "Soft"),
        ADMIN_FAILURE(25, "Admin Failure", "The message was failed by SparkPost\u2019s configured policies.", "Admin"),
        NO_RCPT(30, "Generic Bounce", "No RCPT No recipient could be determined for the message.", "Hard"),
        GENERIC_BOUCNE(40, "Generic Bounce", "The message failed for unspecified reasons.", "Soft"),
        MAIL_BLOCK(50, "Mail Block", "The message was blocked by the receiver.", "Block"),
        SPAM_BLOCK(51, "Spam Block", "The message was blocked by the receiver as coming from a known spam source.", "Block"),
        SPAM_CONTENT(52, "Spam Content", "The message was blocked by the receiver as spam.", "Block"),
        PROHIBITED_ATTACHMENT(53, "Prohibited Attachment", "The message was blocked by the receiver because it contained an attachment.", "Block"),
        RELAYING_DENIED(54, "Relaying Denied", "The message was blocked by the receiver because relaying is not allowed.", "Block"),
        AUTO_REPLY(60, "Auto-Reply", "The message is an auto-reply/vacation mail.", "Soft"),
        TRANSIENT_FAILURE(70, "Transient Failure", "Message transmission has been temporarily delayed.", "Soft"),
        SUBSCRIBE(80, "Subscribe", "The message is a subscribe request.", "Admin"),
        UNSUBSCRIBE(90, "Unsubscribe", "The message is an unsubscribe request.", "Hard"),
        CHALLENGE_RESPONSE(100, "Challenge-Response", "The message is a challenge-response probe.", "Soft");

        private final int classification;
        private final String bounceName;
        private final String description;
        private final String category;

        private BounceClass(int classification, String bounceName, String description, String category) {
            this.classification = classification;
            this.bounceName = bounceName;
            this.description = description;
            this.category = category;
        }

        public int classification() {
            return this.classification;
        }

        public String bounceName() {
            return this.bounceName;
        }

        public String description() {
            return this.description;
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return "" + this.classification;
        }
    }
}

