/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.sparkpost.model.RecipientAttributes;
import com.sparkpost.model.StoredRecipientList;
import com.yepher.jsondoc.annotations.Description;
import java.util.List;
import java.util.Map;

public class RecipientList
extends Base {
    @Description(value="Short, unique, recipient list identifier. Maximum length - 64 bytes", sample={""})
    private String id = null;
    @Description(value=" Short, pretty/readable recipient list display name, not required to be unique. Maximum length - 64 bytes", sample={""})
    private String name = null;
    @Description(value="Detailed description of the recipient list. Maximum length - 1024 bytes", sample={""})
    private String description = null;
    @Description(value=" Recipient list attribute object", sample={""})
    private Map<String, String> attributes = null;
    @Description(value=" List of recipient objects", sample={""})
    private List<RecipientAttributes> recipients = null;
    @Description(value="The number of recipients in this list that have been accepted", sample={""})
    @SerializedName(value="total_accepted_recipients")
    private int totalAcceptedRecipients;
    @Description(value="The number of recipients in this list that have been rejected", sample={""})
    @SerializedName(value="total_rejected_recipients")
    private int totalRejectedRecipients;

    public StoredRecipientList asStoredRecipientList() {
        StoredRecipientList storedRecipientList = new StoredRecipientList();
        storedRecipientList.setListId(this.getId());
        return storedRecipientList;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<RecipientAttributes> getRecipients() {
        return this.recipients;
    }

    public int getTotalAcceptedRecipients() {
        return this.totalAcceptedRecipients;
    }

    public int getTotalRejectedRecipients() {
        return this.totalRejectedRecipients;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setRecipients(List<RecipientAttributes> recipients) {
        this.recipients = recipients;
    }

    public void setTotalAcceptedRecipients(int totalAcceptedRecipients) {
        this.totalAcceptedRecipients = totalAcceptedRecipients;
    }

    public void setTotalRejectedRecipients(int totalRejectedRecipients) {
        this.totalRejectedRecipients = totalRejectedRecipients;
    }

    public String toString() {
        return "RecipientList(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", recipients=" + this.getRecipients() + ", totalAcceptedRecipients=" + this.getTotalAcceptedRecipients() + ", totalRejectedRecipients=" + this.getTotalRejectedRecipients() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipientList)) {
            return false;
        }
        RecipientList other = (RecipientList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalAcceptedRecipients() != other.getTotalAcceptedRecipients()) {
            return false;
        }
        if (this.getTotalRejectedRecipients() != other.getTotalRejectedRecipients()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<RecipientAttributes> this$recipients = this.getRecipients();
        List<RecipientAttributes> other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecipientList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalAcceptedRecipients();
        result = result * 59 + this.getTotalRejectedRecipients();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<RecipientAttributes> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }
}

