/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;
import java.util.HashSet;
import java.util.Set;

public class SubaccountInfo
extends Base {
    public static final transient String SMTP_INJECTION_GRANT = "smtp/inject";
    public static final transient String SENDING_DOMAIN_MANAGE_GRANT = "sending_domains/manage";
    public static final transient String TRACKING_DOMAINS_VIEW_GRANT = "tracking_domains/view";
    public static final transient String TRACKING_DOMAINS_MANAGE_GRANT = "tracking_domains/manage";
    public static final transient String MESSAGE_EVENTS_VIEW_GRANT = "message_events/view";
    public static final transient String SUPPRESSION_LISTS_MANAGE_GRANT = "suppression_lists/manage";
    public static final transient String TRANSMISSIONS_VIEW_GRANT = "*transmissions/view";
    public static final transient String TRANSMISSION_MODIFY_GRANT = "transmissions/modify";
    public static final transient String WEBHOOKS_VIEW_GRANT = "webhooks/view";
    public static final transient String WEBHOOKS_MODIFY_GRANT = "webhooks/modify";
    @Description(value="The ID of an IP Pool in which to restrict this subaccount's mail deliveries", sample={"Pool Name"})
    @SerializedName(value="ip_pool")
    private String ipPool;
    @Description(value=" Whether or not to create an API key for the subaccount. An API key can be created a later time. default is true", sample={"true"})
    @SerializedName(value="setup_api_key")
    private Boolean setupApiKey = true;
    @Description(value="User friendly identifier for the initial subaccount api key. Required if setup_api_key is true", sample={"API Key for Sparkle Ponies Subaccount"})
    @SerializedName(value="key_label")
    private String keyLabel;
    @Description(value="List of grants to give to the initial subaccount api key", sample={"SubaccountInfo.SMTP_INJECTION_GRANT"})
    @SerializedName(value="key_grants")
    private Set<String> keyGrants = new HashSet<String>();
    @Description(value="Subaccount display name Max length: 64 characters", sample={"Sparkle Ponies"})
    private String name;

    public void addKeyGrant(String keyGrant) {
        this.keyGrants.add(keyGrant);
    }

    public String getIpPool() {
        return this.ipPool;
    }

    public Boolean getSetupApiKey() {
        return this.setupApiKey;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public Set<String> getKeyGrants() {
        return this.keyGrants;
    }

    public String getName() {
        return this.name;
    }

    public void setIpPool(String ipPool) {
        this.ipPool = ipPool;
    }

    public void setSetupApiKey(Boolean setupApiKey) {
        this.setupApiKey = setupApiKey;
    }

    public void setKeyLabel(String keyLabel) {
        this.keyLabel = keyLabel;
    }

    public void setKeyGrants(Set<String> keyGrants) {
        this.keyGrants = keyGrants;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "SubaccountInfo(ipPool=" + this.getIpPool() + ", setupApiKey=" + this.getSetupApiKey() + ", keyLabel=" + this.getKeyLabel() + ", keyGrants=" + this.getKeyGrants() + ", name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubaccountInfo)) {
            return false;
        }
        SubaccountInfo other = (SubaccountInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$setupApiKey = this.getSetupApiKey();
        Boolean other$setupApiKey = other.getSetupApiKey();
        if (this$setupApiKey == null ? other$setupApiKey != null : !((Object)this$setupApiKey).equals(other$setupApiKey)) {
            return false;
        }
        String this$ipPool = this.getIpPool();
        String other$ipPool = other.getIpPool();
        if (this$ipPool == null ? other$ipPool != null : !this$ipPool.equals(other$ipPool)) {
            return false;
        }
        String this$keyLabel = this.getKeyLabel();
        String other$keyLabel = other.getKeyLabel();
        if (this$keyLabel == null ? other$keyLabel != null : !this$keyLabel.equals(other$keyLabel)) {
            return false;
        }
        Set<String> this$keyGrants = this.getKeyGrants();
        Set<String> other$keyGrants = other.getKeyGrants();
        if (this$keyGrants == null ? other$keyGrants != null : !((Object)this$keyGrants).equals(other$keyGrants)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubaccountInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $setupApiKey = this.getSetupApiKey();
        result = result * 59 + ($setupApiKey == null ? 43 : ((Object)$setupApiKey).hashCode());
        String $ipPool = this.getIpPool();
        result = result * 59 + ($ipPool == null ? 43 : $ipPool.hashCode());
        String $keyLabel = this.getKeyLabel();
        result = result * 59 + ($keyLabel == null ? 43 : $keyLabel.hashCode());
        Set<String> $keyGrants = this.getKeyGrants();
        result = result * 59 + ($keyGrants == null ? 43 : ((Object)$keyGrants).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

