/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;

public class SuppressionListEntry
extends Base {
    @Description(value="Email Address", sample={"address@example.com"})
    private String email;
    @Deprecated
    @Description(value="Whether the recipient requested to not receive any transactional messages. At a minimum, transactional or non_transactional is required upon creation of the entry.", sample={"true"})
    private boolean transactional;
    @Description(value="Whether the recipient requested to not receive any non-transactional messages. At a minimum, transactional or non_transactional is required upon creation of the entry.", sample={"false"})
    @SerializedName(value="non_transactional")
    @Deprecated
    private boolean nonTransactional;
    @Description(value="Source responsible for inserting the list entry. Valid values include: FBL, List Unsubscribe, Bounce Rule, Unsubscribe Link, Manually Added, Compliance. Defaults to Manually Added on create", sample={"Manually Added"})
    private String source = "Manually Added";
    @Description(value="Short explanation of the suppression", sample={"Unsubscribed using list unsubscribe header"})
    private String description;
    @Description(value="Type of suppression record. See TypeTypes", sample={"transactional or non_transactional"})
    private String type;
    @Description(value="Email address to be suppressed", sample={"recip@example.com"})
    private String recipient;
    @Description(value="Date suppression was created", sample={"2017-10-01T12:00:00+00:00"})
    private String created;
    @Description(value="Last time the suppression was updated", sample={"2017-10-01T12:00:00+00:00"})
    private String updated;
    @Description(value="Which subaccount the recipient is suppressed for. Only returned if suppressed for a specific subaccount.", sample={"0"})
    @SerializedName(value="subaccount_id")
    private int subaccountId;

    public SuppressionListEntry() {
    }

    public SuppressionListEntry(SuppressionListEntry entry) {
        this.email = entry.email;
        this.type = entry.type;
        this.source = entry.source;
        this.description = entry.description;
    }

    public String getEmail() {
        return this.email;
    }

    @Deprecated
    public boolean isTransactional() {
        return this.transactional;
    }

    @Deprecated
    public boolean isNonTransactional() {
        return this.nonTransactional;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public int getSubaccountId() {
        return this.subaccountId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Deprecated
    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Deprecated
    public void setNonTransactional(boolean nonTransactional) {
        this.nonTransactional = nonTransactional;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public void setSubaccountId(int subaccountId) {
        this.subaccountId = subaccountId;
    }

    public String toString() {
        return "SuppressionListEntry(email=" + this.getEmail() + ", transactional=" + this.isTransactional() + ", nonTransactional=" + this.isNonTransactional() + ", source=" + this.getSource() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", recipient=" + this.getRecipient() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", subaccountId=" + this.getSubaccountId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuppressionListEntry)) {
            return false;
        }
        SuppressionListEntry other = (SuppressionListEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isTransactional() != other.isTransactional()) {
            return false;
        }
        if (this.isNonTransactional() != other.isNonTransactional()) {
            return false;
        }
        if (this.getSubaccountId() != other.getSubaccountId()) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$updated = this.getUpdated();
        String other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !this$updated.equals(other$updated));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuppressionListEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isTransactional() ? 79 : 97);
        result = result * 59 + (this.isNonTransactional() ? 79 : 97);
        result = result * 59 + this.getSubaccountId();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : $updated.hashCode());
        return result;
    }

    public static final class StatusTypes {
        public static final String FBL = "FBL";
        public static final String SPAM_COMPLAING = "Spam Complaint";
        public static final String LIST_UNSUBSCRIBE = "List Unsubscribe";
        public static final String BOUNCE_RULE = "Bounce Rule";
        public static final String UNSUBSCRIBE_LINK = "Unsubscribe Link";
        public static final String MANUALLY_ADDED = "Manually Added";
        public static final String COMPLIANCE = "Compliance";
    }

    public static final class TypeTypes {
        public static final String TRANSACTIONAL_TYPE = "transactional";
        public static final String NON_TRANSACTIONAL_TYPE = "non_transactional";
    }
}

