/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model.responses;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;
import java.lang.reflect.Type;

public class Response
extends Base {
    private static final Gson GSON = new Gson();
    @Description(value="The URI of the request", sample={""})
    private String request = null;
    @Description(value="Request Identifier", sample={""})
    private String requestId = null;
    @Description(value="HTTP Response Code generated by request", sample={"200"})
    private int responseCode = -1;
    @Description(value="The 'Content-Type' returne by the server", sample={"application/json"})
    private String contentType = null;
    @Description(value="The HTTP Message generated by request", sample={"OK"})
    private String responseMessage = null;
    @Description(value="The json of the response", sample={""})
    @SerializedName(value="json")
    private String responseBody = null;

    public static <T extends Response> T decode(Response response, Type typeOfT) {
        Response newResponse = null;
        newResponse = response.getContentType() != null && response.getContentType().toLowerCase().startsWith("application/json") ? (Response)GSON.fromJson(response.getResponseBody(), typeOfT) : (Response)GSON.fromJson("{}", typeOfT);
        if (newResponse != null) {
            newResponse.setRequest(response.request);
            newResponse.setRequestId(response.requestId);
            newResponse.setResponseCode(response.responseCode);
            newResponse.setContentType(response.contentType);
            newResponse.setResponseBody(response.responseBody);
            newResponse.setResponseMessage(response.responseMessage);
        }
        return (T)newResponse;
    }

    public String getRequest() {
        return this.request;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public String toString() {
        return "Response(request=" + this.getRequest() + ", requestId=" + this.getRequestId() + ", responseCode=" + this.getResponseCode() + ", contentType=" + this.getContentType() + ", responseMessage=" + this.getResponseMessage() + ", responseBody=" + this.getResponseBody() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getResponseCode() != other.getResponseCode()) {
            return false;
        }
        String this$request = this.getRequest();
        String other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$responseMessage = this.getResponseMessage();
        String other$responseMessage = other.getResponseMessage();
        if (this$responseMessage == null ? other$responseMessage != null : !this$responseMessage.equals(other$responseMessage)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        return !(this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getResponseCode();
        String $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $responseMessage = this.getResponseMessage();
        result = result * 59 + ($responseMessage == null ? 43 : $responseMessage.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        return result;
    }
}

