/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model.webhook.event;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;
import java.util.List;
import java.util.Map;

public class DeliveryEvent
extends Base {
    @Description(value="Subject line from the email header", sample={"Summer deals are here!"})
    private String subject;
    @SerializedName(value="ab_test_id")
    @Description(value="A/B test of which this event was a part.", sample={"password-reset"})
    private String abTestId;
    @SerializedName(value="rcpt_tags")
    @Description(value="Tags applied to the message which generated this event", sample={"[\"male\",\"US\"]"})
    private List<String> rcptTags;
    @SerializedName(value="scheduled_time")
    @Description(value="Time at which the email was scheduled to be sent", sample={"1588348800"})
    private String scheduledTime;
    @Description(value="Type of event this record describes", sample={"delivery"})
    private String type;
    @SerializedName(value="num_retries")
    @Description(value="Number of failed attempts before this message was successfully delivered; when the first attempt succeeds, zero", sample={"2"})
    private String numRetries;
    @SerializedName(value="sms_dst_npi")
    @Description(value="Destination numbering plan identification", sample={"E164"})
    private String smsDstNpi;
    @SerializedName(value="raw_rcpt_to")
    @Description(value="Actual recipient address used on this message's SMTP envelope", sample={"recipient@example.com"})
    private String rawRcptTo;
    @SerializedName(value="sms_src")
    @Description(value="SMS source address", sample={"1234"})
    private String smsSrc;
    @SerializedName(value="recv_method")
    @Description(value="Protocol by which SparkPost received this message", sample={"esmtp"})
    private String recvMethod;
    @SerializedName(value="subaccount_id")
    @Description(value="Unique subaccount identifier.", sample={"101"})
    private String subaccountId;
    @SerializedName(value="transmission_id")
    @Description(value="Transmission which originated this message", sample={"65832150921904138"})
    private String transmissionId;
    @SerializedName(value="sms_remoteids")
    @Description(value="The message ID(s) in the response, assigned by the remote server/SMSC", sample={"[\"0000\",\"0001\",\"0002\",\"0003\",\"0004\"]"})
    private List<String> smsRemoteids;
    @SerializedName(value="campaign_id")
    @Description(value="Campaign of which this message was a part", sample={"Example Campaign Name"})
    private String campaignId;
    @SerializedName(value="click_tracking")
    @Description(value="Indicates whether or not click tracking was enabled", sample={"true"})
    private int clickTracking;
    @SerializedName(value="rcpt_meta")
    @Description(value="Metadata describing the message recipient", sample={"{\"customKey\":\"customValue\"}"})
    private Map<String, String> rcptMeta;
    @SerializedName(value="queue_time")
    @Description(value="Delay, expressed in milliseconds, between this message's injection into SparkPost and its delivery to the receiving domain; that is, the length of time this message spent in the outgoing queue", sample={"12"})
    private String queueTime;
    @SerializedName(value="sms_dst")
    @Description(value="SMS destination address", sample={"7876712656"})
    private String smsDst;
    @SerializedName(value="routing_domain")
    @Description(value="Domain receiving this message", sample={"example.com"})
    private String routingDomain;
    @SerializedName(value="sending_ip")
    @Description(value="IP address through which this message was sent", sample={"127.0.0.1"})
    private String sendingIp;
    @SerializedName(value="sms_segments")
    @Description(value="Segment number of the log line for large messages sent through multiple SMSes", sample={"5"})
    private int smsSegments;
    @SerializedName(value="amp_enabled")
    @Description(value="Indicates whether or not amp format was enabled", sample={"true"})
    private int ampEnabled;
    @SerializedName(value="rcpt_hash")
    @Description(value="Hashed version of recipient address used on this message's SMTP envelope", sample={"2aae6c35c94fcfb415dbe95f408b9ce91ee846ed"})
    private String rcptHash;
    @Description(value="Indicates if the transmission was marked as transactional", sample={"1"})
    private String transactional;
    @SerializedName(value="sms_src_npi")
    @Description(value="Source numbering plan identification", sample={"E164"})
    private String smsSrcNpi;
    @SerializedName(value="template_version")
    @Description(value="Version of the template used to construct this message", sample={"1"})
    private String templateVersion;
    @SerializedName(value="friendly_from")
    @Description(value="Friendly sender or 'From' header in the original email", sample={"sender@example.com"})
    private String friendlyFrom;
    @SerializedName(value="ip_pool")
    @Description(value="IP pool through which this message was sent", sample={"example-ip-pool"})
    private String ipPool;
    @SerializedName(value="msg_from")
    @Description(value="Sender address used on this message's SMTP envelope", sample={"sender@example.com"})
    private String msgFrom;
    @SerializedName(value="rcpt_to")
    @Description(value="Lowercase version of recipient address used on this message's SMTP envelope", sample={"recipient@example.com"})
    private String rcptTo;
    @Description(value="Event date and time, in Unix timestamp format (integer seconds since 00:00:00 GMT 1970-01-01)", sample={"1460989507"})
    private String timestamp;
    @SerializedName(value="ab_test_version")
    @Description(value="A/B test version that was used for this event.", sample={"1"})
    private String abTestVersion;
    @SerializedName(value="sms_coding")
    @Description(value="Data encoding used in the SMS message", sample={"ASCII"})
    private String smsCoding;
    @SerializedName(value="outbound_tls")
    @Description(value="Whether a message was sent using TLS or not. Specifies if a message wasn't sent with TLS either because no TLS was offered or TLS negotiation failed. 1 means TLS was used, 0 means TLS was not offered, -1 means TLS negotiation failed", sample={"-1"})
    private String outboundTls;
    @SerializedName(value="message_id")
    @Description(value="SparkPost-cluster-wide unique identifier for this message", sample={"000443ee14578172be22"})
    private String messageId;
    @SerializedName(value="ip_address")
    @Description(value="IP address of the host to which SparkPost delivered this message; in engagement events, the IP address of the host where the HTTP request originated", sample={"127.0.0.1"})
    private String ipAddress;
    @SerializedName(value="initial_pixel")
    @Description(value="Indicates whether or not initial open pixel tracking was enabled", sample={"true"})
    private int initialPixel;
    @SerializedName(value="rcpt_type")
    @Description(value="Indicates that a recipient address appeared in the Cc or Bcc header or the archive JSON array", sample={"cc"})
    private String rcptType;
    @SerializedName(value="recipient_domain")
    @Description(value="Domain part of the recipient address used on this message's SMTP envelope", sample={"example.com"})
    private String recipientDomain;
    @SerializedName(value="event_id")
    @Description(value="Unique event identifier", sample={"92356927693813856"})
    private String eventId;
    @SerializedName(value="sms_src_ton")
    @Description(value="Type of number for the source address", sample={"Unknown"})
    private String smsSrcTon;
    @SerializedName(value="device_token")
    @Description(value="Token of the device / application targeted by this PUSH notification message. Applies only when delv_method is gcm or apn.", sample={"45c19189783f867973f6e6a5cca60061ffe4fa77c547150563a1192fa9847f8a"})
    private String deviceToken;
    @SerializedName(value="sms_dst_ton")
    @Description(value="Type of number for the destination address", sample={"International"})
    private String smsDstTon;
    @SerializedName(value="template_id")
    @Description(value="Slug of the template used to construct this message", sample={"templ-1234"})
    private String templateId;
    @SerializedName(value="delv_method")
    @Description(value="Protocol by which SparkPost delivered this message", sample={"esmtp"})
    private String delvMethod;
    @SerializedName(value="customer_id")
    @Description(value="SparkPost-customer identifier through which this message was sent", sample={"1"})
    private String customerId;
    @SerializedName(value="open_tracking")
    @Description(value="Indicates whether or not open tracking was enabled", sample={"true"})
    private int openTracking;
    @SerializedName(value="injection_time")
    @Description(value="Time at which this message was injected into SparkPost", sample={"2016-04-18T14:25:07.000Z"})
    private String injectionTime;
    @SerializedName(value="msg_size")
    @Description(value="Message's size in bytes", sample={"1337"})
    private String msgSize;

    public String getSubject() {
        return this.subject;
    }

    public String getAbTestId() {
        return this.abTestId;
    }

    public List<String> getRcptTags() {
        return this.rcptTags;
    }

    public String getScheduledTime() {
        return this.scheduledTime;
    }

    public String getType() {
        return this.type;
    }

    public String getNumRetries() {
        return this.numRetries;
    }

    public String getSmsDstNpi() {
        return this.smsDstNpi;
    }

    public String getRawRcptTo() {
        return this.rawRcptTo;
    }

    public String getSmsSrc() {
        return this.smsSrc;
    }

    public String getRecvMethod() {
        return this.recvMethod;
    }

    public String getSubaccountId() {
        return this.subaccountId;
    }

    public String getTransmissionId() {
        return this.transmissionId;
    }

    public List<String> getSmsRemoteids() {
        return this.smsRemoteids;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public int getClickTracking() {
        return this.clickTracking;
    }

    public Map<String, String> getRcptMeta() {
        return this.rcptMeta;
    }

    public String getQueueTime() {
        return this.queueTime;
    }

    public String getSmsDst() {
        return this.smsDst;
    }

    public String getRoutingDomain() {
        return this.routingDomain;
    }

    public String getSendingIp() {
        return this.sendingIp;
    }

    public int getSmsSegments() {
        return this.smsSegments;
    }

    public int getAmpEnabled() {
        return this.ampEnabled;
    }

    public String getRcptHash() {
        return this.rcptHash;
    }

    public String getTransactional() {
        return this.transactional;
    }

    public String getSmsSrcNpi() {
        return this.smsSrcNpi;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public String getFriendlyFrom() {
        return this.friendlyFrom;
    }

    public String getIpPool() {
        return this.ipPool;
    }

    public String getMsgFrom() {
        return this.msgFrom;
    }

    public String getRcptTo() {
        return this.rcptTo;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getAbTestVersion() {
        return this.abTestVersion;
    }

    public String getSmsCoding() {
        return this.smsCoding;
    }

    public String getOutboundTls() {
        return this.outboundTls;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getInitialPixel() {
        return this.initialPixel;
    }

    public String getRcptType() {
        return this.rcptType;
    }

    public String getRecipientDomain() {
        return this.recipientDomain;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getSmsSrcTon() {
        return this.smsSrcTon;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public String getSmsDstTon() {
        return this.smsDstTon;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getDelvMethod() {
        return this.delvMethod;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public int getOpenTracking() {
        return this.openTracking;
    }

    public String getInjectionTime() {
        return this.injectionTime;
    }

    public String getMsgSize() {
        return this.msgSize;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setAbTestId(String abTestId) {
        this.abTestId = abTestId;
    }

    public void setRcptTags(List<String> rcptTags) {
        this.rcptTags = rcptTags;
    }

    public void setScheduledTime(String scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setNumRetries(String numRetries) {
        this.numRetries = numRetries;
    }

    public void setSmsDstNpi(String smsDstNpi) {
        this.smsDstNpi = smsDstNpi;
    }

    public void setRawRcptTo(String rawRcptTo) {
        this.rawRcptTo = rawRcptTo;
    }

    public void setSmsSrc(String smsSrc) {
        this.smsSrc = smsSrc;
    }

    public void setRecvMethod(String recvMethod) {
        this.recvMethod = recvMethod;
    }

    public void setSubaccountId(String subaccountId) {
        this.subaccountId = subaccountId;
    }

    public void setTransmissionId(String transmissionId) {
        this.transmissionId = transmissionId;
    }

    public void setSmsRemoteids(List<String> smsRemoteids) {
        this.smsRemoteids = smsRemoteids;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setClickTracking(int clickTracking) {
        this.clickTracking = clickTracking;
    }

    public void setRcptMeta(Map<String, String> rcptMeta) {
        this.rcptMeta = rcptMeta;
    }

    public void setQueueTime(String queueTime) {
        this.queueTime = queueTime;
    }

    public void setSmsDst(String smsDst) {
        this.smsDst = smsDst;
    }

    public void setRoutingDomain(String routingDomain) {
        this.routingDomain = routingDomain;
    }

    public void setSendingIp(String sendingIp) {
        this.sendingIp = sendingIp;
    }

    public void setSmsSegments(int smsSegments) {
        this.smsSegments = smsSegments;
    }

    public void setAmpEnabled(int ampEnabled) {
        this.ampEnabled = ampEnabled;
    }

    public void setRcptHash(String rcptHash) {
        this.rcptHash = rcptHash;
    }

    public void setTransactional(String transactional) {
        this.transactional = transactional;
    }

    public void setSmsSrcNpi(String smsSrcNpi) {
        this.smsSrcNpi = smsSrcNpi;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public void setFriendlyFrom(String friendlyFrom) {
        this.friendlyFrom = friendlyFrom;
    }

    public void setIpPool(String ipPool) {
        this.ipPool = ipPool;
    }

    public void setMsgFrom(String msgFrom) {
        this.msgFrom = msgFrom;
    }

    public void setRcptTo(String rcptTo) {
        this.rcptTo = rcptTo;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setAbTestVersion(String abTestVersion) {
        this.abTestVersion = abTestVersion;
    }

    public void setSmsCoding(String smsCoding) {
        this.smsCoding = smsCoding;
    }

    public void setOutboundTls(String outboundTls) {
        this.outboundTls = outboundTls;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setInitialPixel(int initialPixel) {
        this.initialPixel = initialPixel;
    }

    public void setRcptType(String rcptType) {
        this.rcptType = rcptType;
    }

    public void setRecipientDomain(String recipientDomain) {
        this.recipientDomain = recipientDomain;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setSmsSrcTon(String smsSrcTon) {
        this.smsSrcTon = smsSrcTon;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public void setSmsDstTon(String smsDstTon) {
        this.smsDstTon = smsDstTon;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setDelvMethod(String delvMethod) {
        this.delvMethod = delvMethod;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setOpenTracking(int openTracking) {
        this.openTracking = openTracking;
    }

    public void setInjectionTime(String injectionTime) {
        this.injectionTime = injectionTime;
    }

    public void setMsgSize(String msgSize) {
        this.msgSize = msgSize;
    }

    public String toString() {
        return "DeliveryEvent(subject=" + this.getSubject() + ", abTestId=" + this.getAbTestId() + ", rcptTags=" + this.getRcptTags() + ", scheduledTime=" + this.getScheduledTime() + ", type=" + this.getType() + ", numRetries=" + this.getNumRetries() + ", smsDstNpi=" + this.getSmsDstNpi() + ", rawRcptTo=" + this.getRawRcptTo() + ", smsSrc=" + this.getSmsSrc() + ", recvMethod=" + this.getRecvMethod() + ", subaccountId=" + this.getSubaccountId() + ", transmissionId=" + this.getTransmissionId() + ", smsRemoteids=" + this.getSmsRemoteids() + ", campaignId=" + this.getCampaignId() + ", clickTracking=" + this.getClickTracking() + ", rcptMeta=" + this.getRcptMeta() + ", queueTime=" + this.getQueueTime() + ", smsDst=" + this.getSmsDst() + ", routingDomain=" + this.getRoutingDomain() + ", sendingIp=" + this.getSendingIp() + ", smsSegments=" + this.getSmsSegments() + ", ampEnabled=" + this.getAmpEnabled() + ", rcptHash=" + this.getRcptHash() + ", transactional=" + this.getTransactional() + ", smsSrcNpi=" + this.getSmsSrcNpi() + ", templateVersion=" + this.getTemplateVersion() + ", friendlyFrom=" + this.getFriendlyFrom() + ", ipPool=" + this.getIpPool() + ", msgFrom=" + this.getMsgFrom() + ", rcptTo=" + this.getRcptTo() + ", timestamp=" + this.getTimestamp() + ", abTestVersion=" + this.getAbTestVersion() + ", smsCoding=" + this.getSmsCoding() + ", outboundTls=" + this.getOutboundTls() + ", messageId=" + this.getMessageId() + ", ipAddress=" + this.getIpAddress() + ", initialPixel=" + this.getInitialPixel() + ", rcptType=" + this.getRcptType() + ", recipientDomain=" + this.getRecipientDomain() + ", eventId=" + this.getEventId() + ", smsSrcTon=" + this.getSmsSrcTon() + ", deviceToken=" + this.getDeviceToken() + ", smsDstTon=" + this.getSmsDstTon() + ", templateId=" + this.getTemplateId() + ", delvMethod=" + this.getDelvMethod() + ", customerId=" + this.getCustomerId() + ", openTracking=" + this.getOpenTracking() + ", injectionTime=" + this.getInjectionTime() + ", msgSize=" + this.getMsgSize() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeliveryEvent)) {
            return false;
        }
        DeliveryEvent other = (DeliveryEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClickTracking() != other.getClickTracking()) {
            return false;
        }
        if (this.getSmsSegments() != other.getSmsSegments()) {
            return false;
        }
        if (this.getAmpEnabled() != other.getAmpEnabled()) {
            return false;
        }
        if (this.getInitialPixel() != other.getInitialPixel()) {
            return false;
        }
        if (this.getOpenTracking() != other.getOpenTracking()) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$abTestId = this.getAbTestId();
        String other$abTestId = other.getAbTestId();
        if (this$abTestId == null ? other$abTestId != null : !this$abTestId.equals(other$abTestId)) {
            return false;
        }
        List<String> this$rcptTags = this.getRcptTags();
        List<String> other$rcptTags = other.getRcptTags();
        if (this$rcptTags == null ? other$rcptTags != null : !((Object)this$rcptTags).equals(other$rcptTags)) {
            return false;
        }
        String this$scheduledTime = this.getScheduledTime();
        String other$scheduledTime = other.getScheduledTime();
        if (this$scheduledTime == null ? other$scheduledTime != null : !this$scheduledTime.equals(other$scheduledTime)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$numRetries = this.getNumRetries();
        String other$numRetries = other.getNumRetries();
        if (this$numRetries == null ? other$numRetries != null : !this$numRetries.equals(other$numRetries)) {
            return false;
        }
        String this$smsDstNpi = this.getSmsDstNpi();
        String other$smsDstNpi = other.getSmsDstNpi();
        if (this$smsDstNpi == null ? other$smsDstNpi != null : !this$smsDstNpi.equals(other$smsDstNpi)) {
            return false;
        }
        String this$rawRcptTo = this.getRawRcptTo();
        String other$rawRcptTo = other.getRawRcptTo();
        if (this$rawRcptTo == null ? other$rawRcptTo != null : !this$rawRcptTo.equals(other$rawRcptTo)) {
            return false;
        }
        String this$smsSrc = this.getSmsSrc();
        String other$smsSrc = other.getSmsSrc();
        if (this$smsSrc == null ? other$smsSrc != null : !this$smsSrc.equals(other$smsSrc)) {
            return false;
        }
        String this$recvMethod = this.getRecvMethod();
        String other$recvMethod = other.getRecvMethod();
        if (this$recvMethod == null ? other$recvMethod != null : !this$recvMethod.equals(other$recvMethod)) {
            return false;
        }
        String this$subaccountId = this.getSubaccountId();
        String other$subaccountId = other.getSubaccountId();
        if (this$subaccountId == null ? other$subaccountId != null : !this$subaccountId.equals(other$subaccountId)) {
            return false;
        }
        String this$transmissionId = this.getTransmissionId();
        String other$transmissionId = other.getTransmissionId();
        if (this$transmissionId == null ? other$transmissionId != null : !this$transmissionId.equals(other$transmissionId)) {
            return false;
        }
        List<String> this$smsRemoteids = this.getSmsRemoteids();
        List<String> other$smsRemoteids = other.getSmsRemoteids();
        if (this$smsRemoteids == null ? other$smsRemoteids != null : !((Object)this$smsRemoteids).equals(other$smsRemoteids)) {
            return false;
        }
        String this$campaignId = this.getCampaignId();
        String other$campaignId = other.getCampaignId();
        if (this$campaignId == null ? other$campaignId != null : !this$campaignId.equals(other$campaignId)) {
            return false;
        }
        Map<String, String> this$rcptMeta = this.getRcptMeta();
        Map<String, String> other$rcptMeta = other.getRcptMeta();
        if (this$rcptMeta == null ? other$rcptMeta != null : !((Object)this$rcptMeta).equals(other$rcptMeta)) {
            return false;
        }
        String this$queueTime = this.getQueueTime();
        String other$queueTime = other.getQueueTime();
        if (this$queueTime == null ? other$queueTime != null : !this$queueTime.equals(other$queueTime)) {
            return false;
        }
        String this$smsDst = this.getSmsDst();
        String other$smsDst = other.getSmsDst();
        if (this$smsDst == null ? other$smsDst != null : !this$smsDst.equals(other$smsDst)) {
            return false;
        }
        String this$routingDomain = this.getRoutingDomain();
        String other$routingDomain = other.getRoutingDomain();
        if (this$routingDomain == null ? other$routingDomain != null : !this$routingDomain.equals(other$routingDomain)) {
            return false;
        }
        String this$sendingIp = this.getSendingIp();
        String other$sendingIp = other.getSendingIp();
        if (this$sendingIp == null ? other$sendingIp != null : !this$sendingIp.equals(other$sendingIp)) {
            return false;
        }
        String this$rcptHash = this.getRcptHash();
        String other$rcptHash = other.getRcptHash();
        if (this$rcptHash == null ? other$rcptHash != null : !this$rcptHash.equals(other$rcptHash)) {
            return false;
        }
        String this$transactional = this.getTransactional();
        String other$transactional = other.getTransactional();
        if (this$transactional == null ? other$transactional != null : !this$transactional.equals(other$transactional)) {
            return false;
        }
        String this$smsSrcNpi = this.getSmsSrcNpi();
        String other$smsSrcNpi = other.getSmsSrcNpi();
        if (this$smsSrcNpi == null ? other$smsSrcNpi != null : !this$smsSrcNpi.equals(other$smsSrcNpi)) {
            return false;
        }
        String this$templateVersion = this.getTemplateVersion();
        String other$templateVersion = other.getTemplateVersion();
        if (this$templateVersion == null ? other$templateVersion != null : !this$templateVersion.equals(other$templateVersion)) {
            return false;
        }
        String this$friendlyFrom = this.getFriendlyFrom();
        String other$friendlyFrom = other.getFriendlyFrom();
        if (this$friendlyFrom == null ? other$friendlyFrom != null : !this$friendlyFrom.equals(other$friendlyFrom)) {
            return false;
        }
        String this$ipPool = this.getIpPool();
        String other$ipPool = other.getIpPool();
        if (this$ipPool == null ? other$ipPool != null : !this$ipPool.equals(other$ipPool)) {
            return false;
        }
        String this$msgFrom = this.getMsgFrom();
        String other$msgFrom = other.getMsgFrom();
        if (this$msgFrom == null ? other$msgFrom != null : !this$msgFrom.equals(other$msgFrom)) {
            return false;
        }
        String this$rcptTo = this.getRcptTo();
        String other$rcptTo = other.getRcptTo();
        if (this$rcptTo == null ? other$rcptTo != null : !this$rcptTo.equals(other$rcptTo)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$abTestVersion = this.getAbTestVersion();
        String other$abTestVersion = other.getAbTestVersion();
        if (this$abTestVersion == null ? other$abTestVersion != null : !this$abTestVersion.equals(other$abTestVersion)) {
            return false;
        }
        String this$smsCoding = this.getSmsCoding();
        String other$smsCoding = other.getSmsCoding();
        if (this$smsCoding == null ? other$smsCoding != null : !this$smsCoding.equals(other$smsCoding)) {
            return false;
        }
        String this$outboundTls = this.getOutboundTls();
        String other$outboundTls = other.getOutboundTls();
        if (this$outboundTls == null ? other$outboundTls != null : !this$outboundTls.equals(other$outboundTls)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$rcptType = this.getRcptType();
        String other$rcptType = other.getRcptType();
        if (this$rcptType == null ? other$rcptType != null : !this$rcptType.equals(other$rcptType)) {
            return false;
        }
        String this$recipientDomain = this.getRecipientDomain();
        String other$recipientDomain = other.getRecipientDomain();
        if (this$recipientDomain == null ? other$recipientDomain != null : !this$recipientDomain.equals(other$recipientDomain)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        String this$smsSrcTon = this.getSmsSrcTon();
        String other$smsSrcTon = other.getSmsSrcTon();
        if (this$smsSrcTon == null ? other$smsSrcTon != null : !this$smsSrcTon.equals(other$smsSrcTon)) {
            return false;
        }
        String this$deviceToken = this.getDeviceToken();
        String other$deviceToken = other.getDeviceToken();
        if (this$deviceToken == null ? other$deviceToken != null : !this$deviceToken.equals(other$deviceToken)) {
            return false;
        }
        String this$smsDstTon = this.getSmsDstTon();
        String other$smsDstTon = other.getSmsDstTon();
        if (this$smsDstTon == null ? other$smsDstTon != null : !this$smsDstTon.equals(other$smsDstTon)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$delvMethod = this.getDelvMethod();
        String other$delvMethod = other.getDelvMethod();
        if (this$delvMethod == null ? other$delvMethod != null : !this$delvMethod.equals(other$delvMethod)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$injectionTime = this.getInjectionTime();
        String other$injectionTime = other.getInjectionTime();
        if (this$injectionTime == null ? other$injectionTime != null : !this$injectionTime.equals(other$injectionTime)) {
            return false;
        }
        String this$msgSize = this.getMsgSize();
        String other$msgSize = other.getMsgSize();
        return !(this$msgSize == null ? other$msgSize != null : !this$msgSize.equals(other$msgSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeliveryEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getClickTracking();
        result = result * 59 + this.getSmsSegments();
        result = result * 59 + this.getAmpEnabled();
        result = result * 59 + this.getInitialPixel();
        result = result * 59 + this.getOpenTracking();
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $abTestId = this.getAbTestId();
        result = result * 59 + ($abTestId == null ? 43 : $abTestId.hashCode());
        List<String> $rcptTags = this.getRcptTags();
        result = result * 59 + ($rcptTags == null ? 43 : ((Object)$rcptTags).hashCode());
        String $scheduledTime = this.getScheduledTime();
        result = result * 59 + ($scheduledTime == null ? 43 : $scheduledTime.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $numRetries = this.getNumRetries();
        result = result * 59 + ($numRetries == null ? 43 : $numRetries.hashCode());
        String $smsDstNpi = this.getSmsDstNpi();
        result = result * 59 + ($smsDstNpi == null ? 43 : $smsDstNpi.hashCode());
        String $rawRcptTo = this.getRawRcptTo();
        result = result * 59 + ($rawRcptTo == null ? 43 : $rawRcptTo.hashCode());
        String $smsSrc = this.getSmsSrc();
        result = result * 59 + ($smsSrc == null ? 43 : $smsSrc.hashCode());
        String $recvMethod = this.getRecvMethod();
        result = result * 59 + ($recvMethod == null ? 43 : $recvMethod.hashCode());
        String $subaccountId = this.getSubaccountId();
        result = result * 59 + ($subaccountId == null ? 43 : $subaccountId.hashCode());
        String $transmissionId = this.getTransmissionId();
        result = result * 59 + ($transmissionId == null ? 43 : $transmissionId.hashCode());
        List<String> $smsRemoteids = this.getSmsRemoteids();
        result = result * 59 + ($smsRemoteids == null ? 43 : ((Object)$smsRemoteids).hashCode());
        String $campaignId = this.getCampaignId();
        result = result * 59 + ($campaignId == null ? 43 : $campaignId.hashCode());
        Map<String, String> $rcptMeta = this.getRcptMeta();
        result = result * 59 + ($rcptMeta == null ? 43 : ((Object)$rcptMeta).hashCode());
        String $queueTime = this.getQueueTime();
        result = result * 59 + ($queueTime == null ? 43 : $queueTime.hashCode());
        String $smsDst = this.getSmsDst();
        result = result * 59 + ($smsDst == null ? 43 : $smsDst.hashCode());
        String $routingDomain = this.getRoutingDomain();
        result = result * 59 + ($routingDomain == null ? 43 : $routingDomain.hashCode());
        String $sendingIp = this.getSendingIp();
        result = result * 59 + ($sendingIp == null ? 43 : $sendingIp.hashCode());
        String $rcptHash = this.getRcptHash();
        result = result * 59 + ($rcptHash == null ? 43 : $rcptHash.hashCode());
        String $transactional = this.getTransactional();
        result = result * 59 + ($transactional == null ? 43 : $transactional.hashCode());
        String $smsSrcNpi = this.getSmsSrcNpi();
        result = result * 59 + ($smsSrcNpi == null ? 43 : $smsSrcNpi.hashCode());
        String $templateVersion = this.getTemplateVersion();
        result = result * 59 + ($templateVersion == null ? 43 : $templateVersion.hashCode());
        String $friendlyFrom = this.getFriendlyFrom();
        result = result * 59 + ($friendlyFrom == null ? 43 : $friendlyFrom.hashCode());
        String $ipPool = this.getIpPool();
        result = result * 59 + ($ipPool == null ? 43 : $ipPool.hashCode());
        String $msgFrom = this.getMsgFrom();
        result = result * 59 + ($msgFrom == null ? 43 : $msgFrom.hashCode());
        String $rcptTo = this.getRcptTo();
        result = result * 59 + ($rcptTo == null ? 43 : $rcptTo.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $abTestVersion = this.getAbTestVersion();
        result = result * 59 + ($abTestVersion == null ? 43 : $abTestVersion.hashCode());
        String $smsCoding = this.getSmsCoding();
        result = result * 59 + ($smsCoding == null ? 43 : $smsCoding.hashCode());
        String $outboundTls = this.getOutboundTls();
        result = result * 59 + ($outboundTls == null ? 43 : $outboundTls.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $rcptType = this.getRcptType();
        result = result * 59 + ($rcptType == null ? 43 : $rcptType.hashCode());
        String $recipientDomain = this.getRecipientDomain();
        result = result * 59 + ($recipientDomain == null ? 43 : $recipientDomain.hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        String $smsSrcTon = this.getSmsSrcTon();
        result = result * 59 + ($smsSrcTon == null ? 43 : $smsSrcTon.hashCode());
        String $deviceToken = this.getDeviceToken();
        result = result * 59 + ($deviceToken == null ? 43 : $deviceToken.hashCode());
        String $smsDstTon = this.getSmsDstTon();
        result = result * 59 + ($smsDstTon == null ? 43 : $smsDstTon.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $delvMethod = this.getDelvMethod();
        result = result * 59 + ($delvMethod == null ? 43 : $delvMethod.hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $injectionTime = this.getInjectionTime();
        result = result * 59 + ($injectionTime == null ? 43 : $injectionTime.hashCode());
        String $msgSize = this.getMsgSize();
        result = result * 59 + ($msgSize == null ? 43 : $msgSize.hashCode());
        return result;
    }
}

