/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.model.webhook.event;

import com.google.gson.annotations.SerializedName;
import com.sparkpost.model.Base;
import com.yepher.jsondoc.annotations.Description;
import java.util.List;
import java.util.Map;

public class PolicyRejectionEvent
extends Base {
    @Description(value="Canonicalized text of the response returned by the remote server due to a failed delivery attempt", sample={"MAIL REFUSED - IP (a.b.c.d) is in black list"})
    private String reason;
    @SerializedName(value="template_version")
    @Description(value="Version of the template used to construct this message", sample={"1"})
    private String templateVersion;
    @SerializedName(value="friendly_from")
    @Description(value="Friendly sender or 'From' header in the original email", sample={"sender@example.com"})
    private String friendlyFrom;
    @SerializedName(value="ab_test_id")
    @Description(value="A/B test of which this event was a part.", sample={"password-reset"})
    private String abTestId;
    @SerializedName(value="ip_pool")
    @Description(value="IP pool through which this message was sent", sample={"example-ip-pool"})
    private String ipPool;
    @SerializedName(value="rcpt_tags")
    @Description(value="Tags applied to the message which generated this event", sample={"[\"male\",\"US\"]"})
    private List<String> rcptTags;
    @Description(value="Type of event this record describes", sample={"policy_rejection"})
    private String type;
    @SerializedName(value="raw_rcpt_to")
    @Description(value="Actual recipient address used on this message's SMTP envelope", sample={"recipient@example.com"})
    private String rawRcptTo;
    @SerializedName(value="bounce_class")
    @Description(value="Classification code for a given message (see [Bounce Classification Codes](https://support.sparkpost.com/customer/portal/articles/1929896))", sample={"25"})
    private String bounceClass;
    @SerializedName(value="msg_from")
    @Description(value="Sender address used on this message's SMTP envelope", sample={"sender@example.com"})
    private String msgFrom;
    @SerializedName(value="recv_method")
    @Description(value="Protocol by which SparkPost received this message", sample={"esmtp"})
    private String recvMethod;
    @SerializedName(value="rcpt_to")
    @Description(value="Lowercase version of recipient address used on this message's SMTP envelope", sample={"recipient@example.com"})
    private String rcptTo;
    @SerializedName(value="subaccount_id")
    @Description(value="Unique subaccount identifier.", sample={"101"})
    private String subaccountId;
    @SerializedName(value="transmission_id")
    @Description(value="Transmission which originated this message", sample={"65832150921904138"})
    private String transmissionId;
    @SerializedName(value="campaign_id")
    @Description(value="Campaign of which this message was a part", sample={"Example Campaign Name"})
    private String campaignId;
    @Description(value="Event date and time, in Unix timestamp format (integer seconds since 00:00:00 GMT 1970-01-01)", sample={"1460989507"})
    private String timestamp;
    @SerializedName(value="ab_test_version")
    @Description(value="A/B test version that was used for this event.", sample={"1"})
    private String abTestVersion;
    @SerializedName(value="remote_addr")
    @Description(value="IP address of the host from which SparkPost received this message", sample={"127.0.0.1"})
    private String remoteAddr;
    @SerializedName(value="rcpt_meta")
    @Description(value="Metadata describing the message recipient", sample={"{\"customKey\":\"customValue\"}"})
    private Map<String, String> rcptMeta;
    @SerializedName(value="message_id")
    @Description(value="SparkPost-cluster-wide unique identifier for this message", sample={"000443ee14578172be22"})
    private String messageId;
    @SerializedName(value="rcpt_type")
    @Description(value="Indicates that a recipient address appeared in the Cc or Bcc header or the archive JSON array", sample={"cc"})
    private String rcptType;
    @SerializedName(value="recipient_domain")
    @Description(value="Domain part of the recipient address used on this message's SMTP envelope", sample={"example.com"})
    private String recipientDomain;
    @SerializedName(value="event_id")
    @Description(value="Unique event identifier", sample={"92356927693813856"})
    private String eventId;
    @SerializedName(value="sending_ip")
    @Description(value="IP address through which this message was sent", sample={"127.0.0.1"})
    private String sendingIp;
    @SerializedName(value="raw_reason")
    @Description(value="Unmodified, exact response returned by the remote server due to a failed delivery attempt", sample={"MAIL REFUSED - IP (17.99.99.99) is in black list"})
    private String rawReason;
    @SerializedName(value="error_code")
    @Description(value="Error code by which the remote server described a failed delivery attempt", sample={"554"})
    private String errorCode;
    @SerializedName(value="template_id")
    @Description(value="Slug of the template used to construct this message", sample={"templ-1234"})
    private String templateId;
    @SerializedName(value="customer_id")
    @Description(value="SparkPost-customer identifier through which this message was sent", sample={"1"})
    private String customerId;
    @SerializedName(value="rcpt_hash")
    @Description(value="Hashed version of recipient address used on this message's SMTP envelope", sample={"2aae6c35c94fcfb415dbe95f408b9ce91ee846ed"})
    private String rcptHash;
    @SerializedName(value="injection_time")
    @Description(value="Time at which this message was injected into SparkPost", sample={"2016-04-18T14:25:07.000Z"})
    private String injectionTime;
    @Description(value="Indicates if the transmission was marked as transactional", sample={"1"})
    private String transactional;

    public String getReason() {
        return this.reason;
    }

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public String getFriendlyFrom() {
        return this.friendlyFrom;
    }

    public String getAbTestId() {
        return this.abTestId;
    }

    public String getIpPool() {
        return this.ipPool;
    }

    public List<String> getRcptTags() {
        return this.rcptTags;
    }

    public String getType() {
        return this.type;
    }

    public String getRawRcptTo() {
        return this.rawRcptTo;
    }

    public String getBounceClass() {
        return this.bounceClass;
    }

    public String getMsgFrom() {
        return this.msgFrom;
    }

    public String getRecvMethod() {
        return this.recvMethod;
    }

    public String getRcptTo() {
        return this.rcptTo;
    }

    public String getSubaccountId() {
        return this.subaccountId;
    }

    public String getTransmissionId() {
        return this.transmissionId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getAbTestVersion() {
        return this.abTestVersion;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Map<String, String> getRcptMeta() {
        return this.rcptMeta;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRcptType() {
        return this.rcptType;
    }

    public String getRecipientDomain() {
        return this.recipientDomain;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getSendingIp() {
        return this.sendingIp;
    }

    public String getRawReason() {
        return this.rawReason;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getRcptHash() {
        return this.rcptHash;
    }

    public String getInjectionTime() {
        return this.injectionTime;
    }

    public String getTransactional() {
        return this.transactional;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    public void setFriendlyFrom(String friendlyFrom) {
        this.friendlyFrom = friendlyFrom;
    }

    public void setAbTestId(String abTestId) {
        this.abTestId = abTestId;
    }

    public void setIpPool(String ipPool) {
        this.ipPool = ipPool;
    }

    public void setRcptTags(List<String> rcptTags) {
        this.rcptTags = rcptTags;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRawRcptTo(String rawRcptTo) {
        this.rawRcptTo = rawRcptTo;
    }

    public void setBounceClass(String bounceClass) {
        this.bounceClass = bounceClass;
    }

    public void setMsgFrom(String msgFrom) {
        this.msgFrom = msgFrom;
    }

    public void setRecvMethod(String recvMethod) {
        this.recvMethod = recvMethod;
    }

    public void setRcptTo(String rcptTo) {
        this.rcptTo = rcptTo;
    }

    public void setSubaccountId(String subaccountId) {
        this.subaccountId = subaccountId;
    }

    public void setTransmissionId(String transmissionId) {
        this.transmissionId = transmissionId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setAbTestVersion(String abTestVersion) {
        this.abTestVersion = abTestVersion;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRcptMeta(Map<String, String> rcptMeta) {
        this.rcptMeta = rcptMeta;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setRcptType(String rcptType) {
        this.rcptType = rcptType;
    }

    public void setRecipientDomain(String recipientDomain) {
        this.recipientDomain = recipientDomain;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setSendingIp(String sendingIp) {
        this.sendingIp = sendingIp;
    }

    public void setRawReason(String rawReason) {
        this.rawReason = rawReason;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setRcptHash(String rcptHash) {
        this.rcptHash = rcptHash;
    }

    public void setInjectionTime(String injectionTime) {
        this.injectionTime = injectionTime;
    }

    public void setTransactional(String transactional) {
        this.transactional = transactional;
    }

    public String toString() {
        return "PolicyRejectionEvent(reason=" + this.getReason() + ", templateVersion=" + this.getTemplateVersion() + ", friendlyFrom=" + this.getFriendlyFrom() + ", abTestId=" + this.getAbTestId() + ", ipPool=" + this.getIpPool() + ", rcptTags=" + this.getRcptTags() + ", type=" + this.getType() + ", rawRcptTo=" + this.getRawRcptTo() + ", bounceClass=" + this.getBounceClass() + ", msgFrom=" + this.getMsgFrom() + ", recvMethod=" + this.getRecvMethod() + ", rcptTo=" + this.getRcptTo() + ", subaccountId=" + this.getSubaccountId() + ", transmissionId=" + this.getTransmissionId() + ", campaignId=" + this.getCampaignId() + ", timestamp=" + this.getTimestamp() + ", abTestVersion=" + this.getAbTestVersion() + ", remoteAddr=" + this.getRemoteAddr() + ", rcptMeta=" + this.getRcptMeta() + ", messageId=" + this.getMessageId() + ", rcptType=" + this.getRcptType() + ", recipientDomain=" + this.getRecipientDomain() + ", eventId=" + this.getEventId() + ", sendingIp=" + this.getSendingIp() + ", rawReason=" + this.getRawReason() + ", errorCode=" + this.getErrorCode() + ", templateId=" + this.getTemplateId() + ", customerId=" + this.getCustomerId() + ", rcptHash=" + this.getRcptHash() + ", injectionTime=" + this.getInjectionTime() + ", transactional=" + this.getTransactional() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolicyRejectionEvent)) {
            return false;
        }
        PolicyRejectionEvent other = (PolicyRejectionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$templateVersion = this.getTemplateVersion();
        String other$templateVersion = other.getTemplateVersion();
        if (this$templateVersion == null ? other$templateVersion != null : !this$templateVersion.equals(other$templateVersion)) {
            return false;
        }
        String this$friendlyFrom = this.getFriendlyFrom();
        String other$friendlyFrom = other.getFriendlyFrom();
        if (this$friendlyFrom == null ? other$friendlyFrom != null : !this$friendlyFrom.equals(other$friendlyFrom)) {
            return false;
        }
        String this$abTestId = this.getAbTestId();
        String other$abTestId = other.getAbTestId();
        if (this$abTestId == null ? other$abTestId != null : !this$abTestId.equals(other$abTestId)) {
            return false;
        }
        String this$ipPool = this.getIpPool();
        String other$ipPool = other.getIpPool();
        if (this$ipPool == null ? other$ipPool != null : !this$ipPool.equals(other$ipPool)) {
            return false;
        }
        List<String> this$rcptTags = this.getRcptTags();
        List<String> other$rcptTags = other.getRcptTags();
        if (this$rcptTags == null ? other$rcptTags != null : !((Object)this$rcptTags).equals(other$rcptTags)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$rawRcptTo = this.getRawRcptTo();
        String other$rawRcptTo = other.getRawRcptTo();
        if (this$rawRcptTo == null ? other$rawRcptTo != null : !this$rawRcptTo.equals(other$rawRcptTo)) {
            return false;
        }
        String this$bounceClass = this.getBounceClass();
        String other$bounceClass = other.getBounceClass();
        if (this$bounceClass == null ? other$bounceClass != null : !this$bounceClass.equals(other$bounceClass)) {
            return false;
        }
        String this$msgFrom = this.getMsgFrom();
        String other$msgFrom = other.getMsgFrom();
        if (this$msgFrom == null ? other$msgFrom != null : !this$msgFrom.equals(other$msgFrom)) {
            return false;
        }
        String this$recvMethod = this.getRecvMethod();
        String other$recvMethod = other.getRecvMethod();
        if (this$recvMethod == null ? other$recvMethod != null : !this$recvMethod.equals(other$recvMethod)) {
            return false;
        }
        String this$rcptTo = this.getRcptTo();
        String other$rcptTo = other.getRcptTo();
        if (this$rcptTo == null ? other$rcptTo != null : !this$rcptTo.equals(other$rcptTo)) {
            return false;
        }
        String this$subaccountId = this.getSubaccountId();
        String other$subaccountId = other.getSubaccountId();
        if (this$subaccountId == null ? other$subaccountId != null : !this$subaccountId.equals(other$subaccountId)) {
            return false;
        }
        String this$transmissionId = this.getTransmissionId();
        String other$transmissionId = other.getTransmissionId();
        if (this$transmissionId == null ? other$transmissionId != null : !this$transmissionId.equals(other$transmissionId)) {
            return false;
        }
        String this$campaignId = this.getCampaignId();
        String other$campaignId = other.getCampaignId();
        if (this$campaignId == null ? other$campaignId != null : !this$campaignId.equals(other$campaignId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$abTestVersion = this.getAbTestVersion();
        String other$abTestVersion = other.getAbTestVersion();
        if (this$abTestVersion == null ? other$abTestVersion != null : !this$abTestVersion.equals(other$abTestVersion)) {
            return false;
        }
        String this$remoteAddr = this.getRemoteAddr();
        String other$remoteAddr = other.getRemoteAddr();
        if (this$remoteAddr == null ? other$remoteAddr != null : !this$remoteAddr.equals(other$remoteAddr)) {
            return false;
        }
        Map<String, String> this$rcptMeta = this.getRcptMeta();
        Map<String, String> other$rcptMeta = other.getRcptMeta();
        if (this$rcptMeta == null ? other$rcptMeta != null : !((Object)this$rcptMeta).equals(other$rcptMeta)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$rcptType = this.getRcptType();
        String other$rcptType = other.getRcptType();
        if (this$rcptType == null ? other$rcptType != null : !this$rcptType.equals(other$rcptType)) {
            return false;
        }
        String this$recipientDomain = this.getRecipientDomain();
        String other$recipientDomain = other.getRecipientDomain();
        if (this$recipientDomain == null ? other$recipientDomain != null : !this$recipientDomain.equals(other$recipientDomain)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        String this$sendingIp = this.getSendingIp();
        String other$sendingIp = other.getSendingIp();
        if (this$sendingIp == null ? other$sendingIp != null : !this$sendingIp.equals(other$sendingIp)) {
            return false;
        }
        String this$rawReason = this.getRawReason();
        String other$rawReason = other.getRawReason();
        if (this$rawReason == null ? other$rawReason != null : !this$rawReason.equals(other$rawReason)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$rcptHash = this.getRcptHash();
        String other$rcptHash = other.getRcptHash();
        if (this$rcptHash == null ? other$rcptHash != null : !this$rcptHash.equals(other$rcptHash)) {
            return false;
        }
        String this$injectionTime = this.getInjectionTime();
        String other$injectionTime = other.getInjectionTime();
        if (this$injectionTime == null ? other$injectionTime != null : !this$injectionTime.equals(other$injectionTime)) {
            return false;
        }
        String this$transactional = this.getTransactional();
        String other$transactional = other.getTransactional();
        return !(this$transactional == null ? other$transactional != null : !this$transactional.equals(other$transactional));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyRejectionEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $templateVersion = this.getTemplateVersion();
        result = result * 59 + ($templateVersion == null ? 43 : $templateVersion.hashCode());
        String $friendlyFrom = this.getFriendlyFrom();
        result = result * 59 + ($friendlyFrom == null ? 43 : $friendlyFrom.hashCode());
        String $abTestId = this.getAbTestId();
        result = result * 59 + ($abTestId == null ? 43 : $abTestId.hashCode());
        String $ipPool = this.getIpPool();
        result = result * 59 + ($ipPool == null ? 43 : $ipPool.hashCode());
        List<String> $rcptTags = this.getRcptTags();
        result = result * 59 + ($rcptTags == null ? 43 : ((Object)$rcptTags).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $rawRcptTo = this.getRawRcptTo();
        result = result * 59 + ($rawRcptTo == null ? 43 : $rawRcptTo.hashCode());
        String $bounceClass = this.getBounceClass();
        result = result * 59 + ($bounceClass == null ? 43 : $bounceClass.hashCode());
        String $msgFrom = this.getMsgFrom();
        result = result * 59 + ($msgFrom == null ? 43 : $msgFrom.hashCode());
        String $recvMethod = this.getRecvMethod();
        result = result * 59 + ($recvMethod == null ? 43 : $recvMethod.hashCode());
        String $rcptTo = this.getRcptTo();
        result = result * 59 + ($rcptTo == null ? 43 : $rcptTo.hashCode());
        String $subaccountId = this.getSubaccountId();
        result = result * 59 + ($subaccountId == null ? 43 : $subaccountId.hashCode());
        String $transmissionId = this.getTransmissionId();
        result = result * 59 + ($transmissionId == null ? 43 : $transmissionId.hashCode());
        String $campaignId = this.getCampaignId();
        result = result * 59 + ($campaignId == null ? 43 : $campaignId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $abTestVersion = this.getAbTestVersion();
        result = result * 59 + ($abTestVersion == null ? 43 : $abTestVersion.hashCode());
        String $remoteAddr = this.getRemoteAddr();
        result = result * 59 + ($remoteAddr == null ? 43 : $remoteAddr.hashCode());
        Map<String, String> $rcptMeta = this.getRcptMeta();
        result = result * 59 + ($rcptMeta == null ? 43 : ((Object)$rcptMeta).hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $rcptType = this.getRcptType();
        result = result * 59 + ($rcptType == null ? 43 : $rcptType.hashCode());
        String $recipientDomain = this.getRecipientDomain();
        result = result * 59 + ($recipientDomain == null ? 43 : $recipientDomain.hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        String $sendingIp = this.getSendingIp();
        result = result * 59 + ($sendingIp == null ? 43 : $sendingIp.hashCode());
        String $rawReason = this.getRawReason();
        result = result * 59 + ($rawReason == null ? 43 : $rawReason.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $rcptHash = this.getRcptHash();
        result = result * 59 + ($rcptHash == null ? 43 : $rcptHash.hashCode());
        String $injectionTime = this.getInjectionTime();
        result = result * 59 + ($injectionTime == null ? 43 : $injectionTime.hashCode());
        String $transactional = this.getTransactional();
        result = result * 59 + ($transactional == null ? 43 : $transactional.hashCode());
        return result;
    }
}

