/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.resources;

import com.sparkpost.exception.SparkPostException;
import com.sparkpost.model.MessageEventsQueryBuilder;
import com.sparkpost.model.responses.MessageEventsResponse;
import com.sparkpost.model.responses.Response;
import com.sparkpost.resources.Endpoint;
import com.sparkpost.transport.IRestConnection;
import java.net.URI;
import java.net.URISyntaxException;

public class ResourceMessageEvents {
    public static MessageEventsResponse searchMessageEvents(IRestConnection conn) throws SparkPostException {
        return ResourceMessageEvents.searchMessageEvents(conn, 0, null);
    }

    public static MessageEventsResponse searchMessageEvents(IRestConnection conn, int perPage) throws SparkPostException {
        return ResourceMessageEvents.searchMessageEvents(conn, perPage, null);
    }

    public static MessageEventsResponse searchMessageEvents(IRestConnection conn, MessageEventsQueryBuilder queryBuilder) throws SparkPostException {
        return ResourceMessageEvents.searchMessageEvents(conn, 0, queryBuilder);
    }

    public static MessageEventsResponse searchMessageEvents(IRestConnection conn, int perPage, MessageEventsQueryBuilder queryBuilder) throws SparkPostException {
        Endpoint ep = new Endpoint("events/message");
        if (queryBuilder != null) {
            queryBuilder.buildQuery(ep);
        }
        if (perPage > 0) {
            ep.addParam("per_page", perPage);
        }
        Response response = conn.get(ep);
        MessageEventsResponse messageResponse = (MessageEventsResponse)MessageEventsResponse.decode(response, MessageEventsResponse.class);
        return messageResponse;
    }

    public static MessageEventsResponse nextMessageEvents(IRestConnection conn, MessageEventsResponse page) throws SparkPostException {
        if (!page.hasNext()) {
            return null;
        }
        String next = page.nextPageUrl();
        try {
            URI uri = new URI(next);
            String path = uri.getPath();
            path = path.replaceFirst("/api/v1/", "");
            Endpoint ep = new Endpoint(path);
            String query = uri.getQuery();
            if (query.length() > 0) {
                String[] split;
                for (String element : split = query.split("&")) {
                    String[] fields = element.split("=", 2);
                    ep.addParam(fields[0], fields[1]);
                }
            }
            Response response = conn.get(ep);
            MessageEventsResponse messageResponse = (MessageEventsResponse)MessageEventsResponse.decode(response, MessageEventsResponse.class);
            return messageResponse;
        }
        catch (URISyntaxException e) {
            throw new SparkPostException(e);
        }
    }
}

