/*
 * Decompiled with CFR 0.152.
 */
package com.sparkpost.transport;

import com.sparkpost.Client;
import com.sparkpost.exception.SparkPostAccessForbiddenException;
import com.sparkpost.exception.SparkPostAuthorizationFailedException;
import com.sparkpost.exception.SparkPostErrorServerResponseException;
import com.sparkpost.exception.SparkPostException;
import com.sparkpost.exception.SparkPostIllegalServerResponseException;
import com.sparkpost.model.responses.Response;
import com.sparkpost.model.responses.ServerErrorResponses;
import com.sparkpost.resources.Endpoint;
import com.sparkpost.transport.IRestConnection;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestConnection
implements IRestConnection {
    private static final Logger logger = LogManager.getLogger(RestConnection.class);
    private static final String VERSION = "0.27 (3d4a672)";
    private static final Base64 BASE64 = new Base64();
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int UNAUTHORIZED_RESPONSE_STATUS_CODE = 401;
    private static final int ACCESS_FORBIDDEN_RESPONSE_STATUS_CODE = 403;
    private final Client client;
    private final String baseUrl;
    private final Map<String, String> extraHeaders = new HashMap<String, String>();

    public RestConnection(Client client) throws SparkPostException {
        this(client, "");
    }

    public RestConnection(Client client, String baseUrl) throws SparkPostException {
        this.client = client;
        this.baseUrl = StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{baseUrl}) ? "https://api.sparkpost.com/api/v1" : baseUrl;
        if (this.baseUrl.endsWith("/")) {
            throw new IllegalStateException("SPARKPOST_BASE_URL should not end with a '/',  SPARKPOST_BASE_URL=" + this.baseUrl + "");
        }
    }

    private HttpURLConnection createConnectionObject(String path, Method method) throws SparkPostException {
        HttpURLConnection conn;
        try {
            URL url = new URL(this.baseUrl + path);
            conn = this.client.getProxy() != null ? (HttpURLConnection)url.openConnection(this.client.getProxy()) : (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.client.getHttpConnectTimeout());
            conn.setReadTimeout(this.client.getHttpReadTimeout());
            if (StringUtils.isNotEmpty((CharSequence)this.client.getAuthKey())) {
                conn.setRequestProperty("Authorization", this.client.getAuthKey());
            } else if (StringUtils.isNotEmpty((CharSequence)this.client.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.client.getPassword())) {
                String encoding = BASE64.encodeAsString((this.client.getUsername() + ":" + this.client.getPassword()).getBytes(DEFAULT_CHARSET));
                conn.setRequestProperty("Authorization", "Basic " + encoding);
            }
            conn.setRequestProperty("User-Agent", "java-sparkpost/0.27 (3d4a672)");
            conn.setRequestProperty("Content-Type", "application/json");
            switch (method) {
                case GET: {
                    conn.setRequestMethod("GET");
                    if (logger.isDebugEnabled()) {
                        logger.debug("GET " + url);
                    }
                    break;
                }
                case POST: {
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("POST " + path);
                    }
                    break;
                }
                case PUT: {
                    conn.setRequestMethod("PUT");
                    conn.setDoOutput(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("PUT " + path);
                    }
                    break;
                }
                case DELETE: {
                    conn.setRequestMethod("DELETE");
                    if (logger.isDebugEnabled()) {
                        logger.debug("DELETE " + path);
                    }
                    break;
                }
                default: {
                    throw new SparkPostException("Invalid Method");
                }
            }
        }
        catch (MalformedURLException ex) {
            throw new SparkPostException("Invalid path: " + path + ex.toString());
        }
        catch (ProtocolException ex) {
            throw new SparkPostException("Invalid method:" + ex.toString());
        }
        catch (IOException ex) {
            throw new SparkPostException("Error with connection to " + path + ex.toString());
        }
        return conn;
    }

    private void sendData(HttpURLConnection conn, String data) throws SparkPostException {
        byte[] bytes = null;
        try {
            bytes = data.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new SparkPostException(e);
        }
        String lenStr = Integer.toString(bytes.length);
        conn.setRequestProperty("Content-Length", lenStr);
        conn.setRequestProperty("Content-Type", "application/json");
        if (logger.isDebugEnabled()) {
            logger.debug("Sending data (" + lenStr + " bytes): " + data);
        }
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(bytes);
            wr.flush();
        }
        catch (IOException ex) {
            throw new SparkPostException("Error sending request data:" + ex.toString());
        }
    }

    private void sendRequest(HttpURLConnection conn, String data, Response response) throws SparkPostException {
        if (data != null) {
            this.sendData(conn, data);
        }
        try {
            int code = conn.getResponseCode();
            response.setResponseCode(code);
            response.setContentType(conn.getHeaderField("Content-Type"));
            String msg = conn.getResponseMessage();
            response.setResponseMessage(msg);
        }
        catch (IOException ex) {
            throw new SparkPostException("Connection error:" + ex.toString());
        }
    }

    private Response receiveResponse(HttpURLConnection conn, Response response) throws SparkPostException {
        StringBuilder sb = new StringBuilder();
        try {
            if (conn.getResponseCode() >= 200 && conn.getResponseCode() <= 299) {
                return this.receiveSuccessResponse(conn, response);
            }
            if (conn.getResponseCode() >= 400 && conn.getResponseCode() <= 499) {
                return this.receiveErrorResponse(conn, response);
            }
            if (conn.getResponseCode() >= 500 && conn.getResponseCode() <= 599) {
                return this.receiveErrorResponse(conn, response);
            }
            throw new SparkPostIllegalServerResponseException("Unexpected server response ContentType(" + conn.getContentType() + ") from " + conn.getURL() + " responseCode(" + conn.getResponseCode() + ") contentLength(" + conn.getContentLength() + ")");
        }
        catch (IOException ex) {
            throw new SparkPostErrorServerResponseException("Error reading server response: " + ex.toString() + ": " + sb.toString() + "(" + response.getResponseMessage() + ")", response.getResponseCode());
        }
    }

    private Response receiveSuccessResponse(HttpURLConnection conn, Response response) throws SparkPostException {
        response.setRequestId(conn.getHeaderField("X-SparkPost-Request-Id"));
        if (conn.getContentLength() == 0) {
            return response;
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), DEFAULT_CHARSET));){
            String line;
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            response.setResponseBody(sb.toString());
        }
        catch (IOException ex) {
            String line = "";
            try {
                try (BufferedReader rd22 = new BufferedReader(new InputStreamReader(conn.getErrorStream(), DEFAULT_CHARSET));){
                    while ((line = rd22.readLine()) != null) {
                        sb.append(line);
                    }
                    response.setResponseBody(sb.toString());
                    logger.error("Server Response:\n" + sb.toString() + "\n");
                }
                catch (IOException rd22) {}
            }
            catch (Exception e) {
                logger.error("Error while handlign an HTTP response error. Ignoring and will use orginal exception", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.error("Server Response:" + response);
            }
            throw new SparkPostErrorServerResponseException("Error reading server response: " + ex.toString() + ": " + sb.toString() + "(" + response.getResponseMessage() + ")", response.getResponseCode());
        }
        return response;
    }

    private Response receiveErrorResponse(HttpURLConnection conn, Response response) throws SparkPostException, IOException {
        response.setRequestId(conn.getHeaderField("X-SparkPost-Request-Id"));
        if (conn.getContentLength() == 0) {
            throw new SparkPostErrorServerResponseException("Unexpected server response ContentType(" + conn.getContentType() + ") from " + conn.getURL() + " contentLength(" + conn.getContentLength() + ")", conn.getResponseCode());
        }
        StringBuilder sb = new StringBuilder();
        ServerErrorResponses errorResponses = null;
        try {
            try (BufferedReader rd2 = new BufferedReader(new InputStreamReader(conn.getErrorStream(), DEFAULT_CHARSET));){
                String line = "";
                while ((line = rd2.readLine()) != null) {
                    sb.append(line);
                }
                response.setResponseBody(sb.toString());
                logger.error("Server Response:\n" + sb.toString() + "\n");
                try {
                    errorResponses = (ServerErrorResponses)ServerErrorResponses.decode(response, ServerErrorResponses.class);
                }
                catch (Exception e) {
                    logger.error("Failed to parse server response:\n", (Throwable)e);
                }
            }
            catch (IOException rd2) {}
        }
        catch (Exception e) {
            logger.error("Error while handling an HTTP response error. Ignoring and will use orginal exception", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.error("Server Response:" + response);
        }
        if (response.getResponseCode() == 401) {
            throw new SparkPostAuthorizationFailedException("Error reading server response: " + sb.toString() + "(" + response.getResponseMessage() + ") responseCode(" + response.getResponseCode() + ")", errorResponses);
        }
        if (response.getResponseCode() == 403) {
            throw new SparkPostAccessForbiddenException("Error reading server response: " + sb.toString() + "(" + response.getResponseMessage() + ") responseCode(" + response.getResponseCode() + ")", errorResponses);
        }
        throw new SparkPostErrorServerResponseException("Error reading server response: " + sb.toString() + "(" + response.getResponseMessage() + ")", response.getResponseCode(), errorResponses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response doHttpMethod(Endpoint endpoint, Method method, String data, Response response) throws SparkPostException {
        HttpURLConnection conn = null;
        try {
            String path = endpoint.toString();
            response.setRequest(path);
            conn = this.createConnectionObject(path, method);
            Set<Map.Entry<String, String>> entrySet = this.extraHeaders.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            this.sendRequest(conn, data, response);
            this.receiveResponse(conn, response);
            if (logger.isDebugEnabled()) {
                logger.debug("Server Response:" + response);
            }
            Response response2 = response;
            return response2;
        }
        finally {
            if (this.client.isDisconnectAfterRequest() && conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public Response get(Endpoint endpoint) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(endpoint, Method.GET, null, response);
    }

    @Override
    public Response post(Endpoint endpoint, String json) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(endpoint, Method.POST, json, response);
    }

    @Override
    public Response put(Endpoint endpoint, String json) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(endpoint, Method.PUT, json, response);
    }

    @Override
    public Response delete(Endpoint endpoint) throws SparkPostException {
        Response response = new Response();
        return this.doHttpMethod(endpoint, Method.DELETE, null, response);
    }

    @Override
    public void addHeader(String key, String value) {
        this.extraHeaders.put(key, value);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

