/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;

public class NakedLocalFileSystem
extends RawLocalFileSystem {
    protected static final boolean IS_WINDOWS_OS = Optional.ofNullable(System.getProperty("os.name")).filter(osName -> osName.startsWith("Windows")).isPresent();
    private long defaultBlockSize;

    protected long getFileSystemDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.defaultBlockSize = this.getDefaultBlockSize(new Path(uri));
    }

    public boolean supportsSymlinks() {
        return false;
    }

    public java.nio.file.Path toNioPath(Path path) {
        return this.pathToFile(path).toPath();
    }

    public static Set<PosixFilePermission> toNioPosixFilePermissions(FsPermission permission) {
        FsAction otherAction;
        FsAction groupAction;
        EnumSet<PosixFilePermission> nioPosixFilePermissions = EnumSet.noneOf(PosixFilePermission.class);
        FsAction userAction = permission.getUserAction();
        if (userAction.implies(FsAction.READ)) {
            nioPosixFilePermissions.add(PosixFilePermission.OWNER_READ);
        }
        if (userAction.implies(FsAction.WRITE)) {
            nioPosixFilePermissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if (userAction.implies(FsAction.EXECUTE)) {
            nioPosixFilePermissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((groupAction = permission.getGroupAction()).implies(FsAction.READ)) {
            nioPosixFilePermissions.add(PosixFilePermission.GROUP_READ);
        }
        if (groupAction.implies(FsAction.WRITE)) {
            nioPosixFilePermissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if (groupAction.implies(FsAction.EXECUTE)) {
            nioPosixFilePermissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((otherAction = permission.getOtherAction()).implies(FsAction.READ)) {
            nioPosixFilePermissions.add(PosixFilePermission.OTHERS_READ);
        }
        if (otherAction.implies(FsAction.WRITE)) {
            nioPosixFilePermissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (otherAction.implies(FsAction.EXECUTE)) {
            nioPosixFilePermissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return nioPosixFilePermissions;
    }

    public static FsPermission toFsPermission(Set<PosixFilePermission> nioPosixFilePermissions) {
        FsAction ownerAction = NakedLocalFileSystem.fsActionOf(nioPosixFilePermissions.contains((Object)PosixFilePermission.OWNER_READ), nioPosixFilePermissions.contains((Object)PosixFilePermission.OWNER_WRITE), nioPosixFilePermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        FsAction groupAction = NakedLocalFileSystem.fsActionOf(nioPosixFilePermissions.contains((Object)PosixFilePermission.GROUP_READ), nioPosixFilePermissions.contains((Object)PosixFilePermission.GROUP_WRITE), nioPosixFilePermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        FsAction otherAction = NakedLocalFileSystem.fsActionOf(nioPosixFilePermissions.contains((Object)PosixFilePermission.OTHERS_READ), nioPosixFilePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE), nioPosixFilePermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        return new FsPermission(ownerAction, groupAction, otherAction);
    }

    public static FsAction fsActionOf(boolean read, boolean write, boolean execute) {
        FsAction result = FsAction.NONE;
        if (read) {
            result = result.or(FsAction.READ);
        }
        if (write) {
            result = result.or(FsAction.WRITE);
        }
        if (execute) {
            result = result.or(FsAction.EXECUTE);
        }
        return result;
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(this.toNioPath(path), PosixFileAttributeView.class, new LinkOption[0]);
        if (posixFileAttributeView != null) {
            posixFileAttributeView.setPermissions(NakedLocalFileSystem.toNioPosixFilePermissions(permission));
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.listStatus(this.toNioPath(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileStatus[] listStatus(java.nio.file.Path nioPath) throws FileNotFoundException, IOException {
        if (!Files.isDirectory(nioPath, LinkOption.NOFOLLOW_LINKS)) {
            return new FileStatus[]{this.getFileStatus(nioPath)};
        }
        try (Stream<java.nio.file.Path> childNioPaths = Files.list(nioPath);){
            FileStatus[] fileStatusArray = (FileStatus[])childNioPaths.map(childNioPath -> {
                try {
                    return this.getFileStatus((java.nio.file.Path)childNioPath);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                catch (IOException ioException) {
                    throw new UncheckedIOException(ioException);
                }
            }).filter(Objects::nonNull).toArray(FileStatus[]::new);
            return fileStatusArray;
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.getFileStatus(this.toNioPath(path));
    }

    public FileStatus getFileStatus(java.nio.file.Path nioPath) throws IOException {
        try {
            PosixFileAttributes nioPosixFileAttributes;
            BasicFileAttributes nioBasicFileAttributes = Files.readAttributes(nioPath, BasicFileAttributes.class, new LinkOption[0]);
            try {
                nioPosixFileAttributes = Files.readAttributes(nioPath, PosixFileAttributes.class, new LinkOption[0]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                nioPosixFileAttributes = null;
            }
            return new NakedLocalFileStatus(nioPath, this.getFileSystemDefaultBlockSize(), nioBasicFileAttributes, nioPosixFileAttributes, (FileSystem)this);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw (FileNotFoundException)new FileNotFoundException(String.format("File `%s` does not exist.", nioPath)).initCause(noSuchFileException);
        }
    }

    public String toString() {
        return "NakedLocalFS";
    }

    protected static class NakedLocalFileStatus
    extends FileStatus {
        private static final long serialVersionUID = 1L;
        private final java.nio.file.Path nioPath;
        private static final String WINDOWS_PRINCIPAL_DOMAIN_NAME_SEPARATOR = "\\";

        public java.nio.file.Path getNioPath() {
            return this.nioPath;
        }

        public NakedLocalFileStatus(java.nio.file.Path nioPath, long blockSize, BasicFileAttributes nioBasicFileAttributes, @Nullable PosixFileAttributes nioPosixFileAttributes, FileSystem fileSystem) throws IOException {
            super(Files.size(nioPath), Files.isDirectory(nioPath, new LinkOption[0]), 1, blockSize, nioBasicFileAttributes.lastModifiedTime().toMillis(), nioBasicFileAttributes.lastAccessTime().toMillis(), nioPosixFileAttributes != null ? NakedLocalFileSystem.toFsPermission(nioPosixFileAttributes.permissions()) : null, nioPosixFileAttributes != null ? NakedLocalFileStatus.removePrincipalDomainIfWindows(nioPosixFileAttributes.owner().getName()) : null, nioPosixFileAttributes != null ? NakedLocalFileStatus.removePrincipalDomainIfWindows(nioPosixFileAttributes.group().getName()) : null, new Path(nioPath.normalize().toString()).makeQualified(fileSystem.getUri(), fileSystem.getWorkingDirectory()));
            this.nioPath = Objects.requireNonNull(nioPath);
        }

        private static String removePrincipalDomainIfWindows(String principalName) {
            int index;
            if (IS_WINDOWS_OS && (index = principalName.indexOf(WINDOWS_PRINCIPAL_DOMAIN_NAME_SEPARATOR)) != -1) {
                principalName = principalName.substring(index + 1);
            }
            return principalName;
        }
    }
}

