/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import com.sparrowwallet.hummingbird.BC32DecoderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BC32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";

    private static int polymod(byte[] values) {
        int c = 1;
        for (byte v_i : values) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static boolean verifyChecksum(byte[] values) {
        byte[] combined = new byte[1 + values.length];
        System.arraycopy(new byte[]{0}, 0, combined, 0, 1);
        System.arraycopy(values, 0, combined, 1, values.length);
        return BC32.polymod(combined) == 0x3FFFFFFF;
    }

    private static byte[] createChecksum(byte[] values) {
        byte[] enc = new byte[1 + values.length + 6];
        System.arraycopy(values, 0, enc, 1, values.length);
        int mod = BC32.polymod(enc) ^ 0x3FFFFFFF;
        byte[] result = new byte[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = (byte)(mod >>> 5 * (5 - i) & 0x1F);
        }
        return result;
    }

    public static String encode(byte[] values) {
        ArrayList<Byte> boxedList = new ArrayList<Byte>(values.length);
        for (byte value : values) {
            boxedList.add(value);
        }
        byte[] data = BC32.convertBits(boxedList, 8, 5, true);
        byte[] checksum = BC32.createChecksum(data);
        byte[] combined = new byte[data.length + checksum.length];
        System.arraycopy(data, 0, combined, 0, data.length);
        System.arraycopy(checksum, 0, combined, data.length, checksum.length);
        StringBuilder sb = new StringBuilder(combined.length);
        for (byte b : combined) {
            sb.append(CHARSET.charAt(b));
        }
        return sb.toString();
    }

    public static byte[] decode(String str) {
        boolean lower = false;
        boolean upper = false;
        if (str.length() < 6) {
            throw new BC32DecoderException.InvalidDataLength("Input too short: " + str.length());
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '!' || c > '~') {
                throw new BC32DecoderException.InvalidCharacter(c, i);
            }
            if (c >= 'a' && c <= 'z') {
                if (upper) {
                    throw new BC32DecoderException.InvalidCharacter(c, i);
                }
                lower = true;
            }
            if (c < 'A' || c > 'Z') continue;
            if (lower) {
                throw new BC32DecoderException.InvalidCharacter(c, i);
            }
            upper = true;
        }
        int dataPartLength = str.length();
        byte[] values = new byte[dataPartLength];
        for (int i = 0; i < dataPartLength; ++i) {
            char c = str.charAt(i);
            if (CHARSET.indexOf(c) == -1) {
                throw new IllegalArgumentException("BC32 characters  out of range");
            }
            values[i] = (byte)CHARSET.indexOf(c);
        }
        if (!BC32.verifyChecksum(values)) {
            throw new BC32DecoderException.InvalidChecksum();
        }
        byte[] data = Arrays.copyOfRange(values, 0, values.length - 6);
        ArrayList<Byte> valueList = new ArrayList<Byte>();
        for (byte b : data) {
            valueList.add(b);
        }
        return BC32.convertBits(valueList, 5, 8, false);
    }

    private static byte[] convertBits(List<Byte> data, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toBits) - 1;
        ArrayList<Byte> ret = new ArrayList<Byte>();
        for (Byte value : data) {
            short b = (short)(value & 0xFF);
            if (b >> fromBits > 0) {
                throw new IllegalArgumentException("Illegal bytes for bc32 encoding");
            }
            acc = acc << fromBits | b;
            bits += fromBits;
            while (bits >= toBits) {
                ret.add((byte)(acc >> (bits -= toBits) & maxv));
            }
        }
        if (pad && bits > 0) {
            ret.add((byte)(acc << toBits - bits & maxv));
        } else if (bits >= fromBits || (byte)(acc << toBits - bits & maxv) != 0) {
            throw new IllegalArgumentException("Illegal bytes for bc32 encoding");
        }
        Object[] boxedArray = ret.toArray();
        int len = boxedArray.length;
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)boxedArray[i]).byteValue();
        }
        return array;
    }
}

