/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import com.sparrowwallet.hummingbird.BC32;
import com.sparrowwallet.hummingbird.LegacyUREncoder;
import com.sparrowwallet.hummingbird.UR;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

@Deprecated
public class LegacyURDecoder {
    private final Set<String> fragments = new LinkedHashSet<String>();

    public void receivePart(String fragment) {
        this.fragments.add(fragment.toLowerCase());
    }

    public boolean isComplete() {
        if (this.fragments.isEmpty()) {
            return false;
        }
        String fragment = this.fragments.iterator().next();
        String[] components = fragment.split("/");
        if (components.length > 3) {
            int[] sequence = LegacyURDecoder.checkAndGetSequence(components[1]);
            int total = sequence[1];
            return total == this.fragments.size();
        }
        return true;
    }

    public double getPercentComplete() {
        int[] sequence;
        int total;
        if (this.fragments.isEmpty()) {
            return 0.0;
        }
        String fragment = this.fragments.iterator().next();
        String[] components = fragment.split("/");
        if (components.length > 3 && (total = (sequence = LegacyURDecoder.checkAndGetSequence(components[1]))[1]) > 0 && this.fragments.size() <= total) {
            return (double)this.fragments.size() / (double)total;
        }
        return 1.0;
    }

    public static boolean isLegacyURFragment(String fragment) {
        String[] components = fragment.split("/");
        if (components.length > 3) {
            return true;
        }
        String payload = components[components.length - 1].toLowerCase();
        if (payload.indexOf(98) > -1 || payload.indexOf(105) > -1 || payload.indexOf(111) > -1) {
            return false;
        }
        return payload.matches(".*\\d.*");
    }

    public UR decode() throws UR.InvalidTypeException {
        return LegacyURDecoder.decode(this.fragments.toArray(new String[0]));
    }

    public static UR decode(String[] fragments) throws UR.InvalidTypeException {
        int length = fragments.length;
        if (length == 1) {
            return LegacyURDecoder.handleFragment(fragments[0]);
        }
        return LegacyURDecoder.handleFragments(fragments);
    }

    private static UR handleFragment(String fragment) throws UR.InvalidTypeException {
        String[] components = fragment.split("/");
        switch (components.length) {
            case 2: {
                return new UR(components[0].substring("ur".length() + 1), BC32.decode(components[1]));
            }
            case 3: {
                String digest = components[1];
                String data = components[2];
                LegacyURDecoder.checkDigest(data, digest);
                return new UR(components[0].substring("ur".length() + 1), BC32.decode(data));
            }
            case 4: {
                LegacyURDecoder.checkAndGetSequence(components[1]);
                String seqDigest = components[2];
                String seqData = components[3];
                LegacyURDecoder.checkDigest(seqDigest, fragment);
                return new UR(components[0].substring("ur".length() + 1), BC32.decode(seqData));
            }
        }
        throw new IllegalArgumentException("Invalid number of fragments: expected 2 / 3 / 4 but got " + components.length);
    }

    private static UR handleFragments(String[] fragments) throws UR.InvalidTypeException {
        int length = fragments.length;
        Object[] parts = new String[length];
        Arrays.fill(parts, "");
        String type = null;
        String digest = null;
        for (String fragment : fragments) {
            String[] components = fragment.split("/");
            if (components.length < 4) {
                throw new IllegalArgumentException(String.format("Invalid fragment: %s, insufficient number of components (%d)", fragment, components.length));
            }
            if (type != null && !type.equals(components[0])) {
                throw new IllegalArgumentException(String.format("Invalid fragment: %s, checksum changed %s, %s", fragment, type, components[0]));
            }
            type = components[0];
            int[] sequence = LegacyURDecoder.checkAndGetSequence(components[1]);
            int index = sequence[0];
            int total = sequence[1];
            if (total != length) {
                throw new IllegalArgumentException(String.format("Invalid fragment: %s, total %d not equals to fragments length %d", fragment, total, length));
            }
            if (digest != null && !digest.equals(components[2])) {
                throw new IllegalArgumentException(String.format("Invalid fragment: %s, checksum changed %s, %s", fragment, digest, components[2]));
            }
            digest = components[2];
            if (((String)parts[index - 1]).length() > 0) {
                throw new IllegalArgumentException(String.format("Invalid fragment: %s, index %d has already been set", fragment, index));
            }
            parts[index - 1] = components[3];
        }
        String payload = (String)Arrays.stream(parts).reduce((cur, acc) -> cur + acc).orElse("");
        LegacyURDecoder.checkDigest(payload, digest);
        if (type == null) {
            throw new IllegalStateException("Type is null");
        }
        return new UR(type.substring("ur".length() + 1), BC32.decode(payload));
    }

    private static void checkDigest(String payload, String digest) {
        MessageDigest sha256Digest = LegacyUREncoder.newDigest();
        sha256Digest.update(BC32.decode(payload));
        byte[] calculatedChecksum = sha256Digest.digest();
        byte[] checksum = BC32.decode(digest);
        if (!Arrays.equals(calculatedChecksum, checksum)) {
            throw new IllegalArgumentException("Invalid digest: " + digest + " for payload: " + payload);
        }
    }

    public static int[] checkAndGetSequence(String payload) {
        String[] pieces = payload.toLowerCase().split("of");
        if (pieces.length != 2) {
            throw new IllegalArgumentException("Invalid sequence: " + payload);
        }
        int index = Integer.parseInt(pieces[0]);
        int total = Integer.parseInt(pieces[1]);
        if (index < 1 || index > total) {
            throw new IllegalArgumentException("Invalid sequence: " + payload);
        }
        return new int[]{index, total};
    }
}

