/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import com.sparrowwallet.hummingbird.BC32;
import com.sparrowwallet.hummingbird.UR;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.stream.IntStream;

@Deprecated
public class LegacyUREncoder {
    public static final int DEFAULT_FRAGMENT_LENGTH = 200;
    private final UR ur;
    private final int fragmentLen;

    public LegacyUREncoder(UR ur) {
        this(ur, 200);
    }

    public LegacyUREncoder(UR ur, int fragmentLen) {
        this.ur = ur;
        this.fragmentLen = fragmentLen;
    }

    public String[] encode() {
        String encoded = BC32.encode(this.ur.getCborBytes());
        MessageDigest sha256Digest = LegacyUREncoder.newDigest();
        sha256Digest.update(this.ur.getCborBytes());
        byte[] checksum = sha256Digest.digest();
        String bc32Checksum = BC32.encode(checksum);
        String[] fragments = this.splitData(encoded, this.fragmentLen);
        return this.composeHeadersToFragments(fragments, bc32Checksum);
    }

    private String[] splitData(String s, int fragmentLen) {
        int count = (int)Math.ceil((float)s.length() / (float)fragmentLen);
        int partLength = (int)Math.ceil((float)s.length() / (float)count);
        String[] fragments = new String[count];
        for (int i = 0; i < count; ++i) {
            fragments[i] = s.substring(partLength * i, Math.min(partLength * (i + 1), s.length()));
        }
        return fragments;
    }

    private String[] composeHeadersToFragments(String[] fragments, String checksum) {
        int length = fragments.length;
        if (length <= 1) {
            return (String[])Arrays.stream(fragments).map(this::composeUR).toArray(String[]::new);
        }
        return (String[])IntStream.range(0, length).mapToObj(i -> this.composeHeadersToFragment(fragments[i], checksum, i, length)).toArray(String[]::new);
    }

    public static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String composeHeadersToFragment(String fragment, String checksum, int index, int total) {
        return this.composeUR(this.composeSequencing(this.composeChecksum(fragment, checksum), index, total));
    }

    private String composeChecksum(String payload, String checksum) {
        return String.format("%s/%s", checksum, payload);
    }

    private String composeSequencing(String payload, int index, int total) {
        return String.format("%dof%d/%s", index + 1, total, payload);
    }

    private String composeUR(String payload) {
        return this.composeUR(payload, this.ur.getType());
    }

    private String composeUR(String payload, String type) {
        return String.format("ur:%s/%s", type, payload);
    }
}

