/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.sparrowwallet.hummingbird.UREncoder;
import com.sparrowwallet.hummingbird.registry.CryptoAccount;
import com.sparrowwallet.hummingbird.registry.CryptoAddress;
import com.sparrowwallet.hummingbird.registry.CryptoBip39;
import com.sparrowwallet.hummingbird.registry.CryptoCoinInfo;
import com.sparrowwallet.hummingbird.registry.CryptoECKey;
import com.sparrowwallet.hummingbird.registry.CryptoHDKey;
import com.sparrowwallet.hummingbird.registry.CryptoKeypath;
import com.sparrowwallet.hummingbird.registry.CryptoOutput;
import com.sparrowwallet.hummingbird.registry.CryptoPSBT;
import com.sparrowwallet.hummingbird.registry.CryptoSeed;
import com.sparrowwallet.hummingbird.registry.CryptoSskr;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.URAccountDescriptor;
import com.sparrowwallet.hummingbird.registry.URAddress;
import com.sparrowwallet.hummingbird.registry.URCoinInfo;
import com.sparrowwallet.hummingbird.registry.URECKey;
import com.sparrowwallet.hummingbird.registry.URHDKey;
import com.sparrowwallet.hummingbird.registry.URKeypath;
import com.sparrowwallet.hummingbird.registry.UROutputDescriptor;
import com.sparrowwallet.hummingbird.registry.URPSBT;
import com.sparrowwallet.hummingbird.registry.URSSKR;
import com.sparrowwallet.hummingbird.registry.URSeed;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UR {
    public static final String UR_PREFIX = "ur";
    private final String type;
    private final byte[] data;

    public UR(RegistryType registryType, byte[] data) throws InvalidTypeException {
        this(registryType.toString(), data);
    }

    public UR(String type, byte[] data) throws InvalidTypeException {
        if (!UR.isURType(type)) {
            throw new InvalidTypeException("Invalid UR type: " + type);
        }
        this.type = type;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public RegistryType getRegistryType() {
        return RegistryType.fromString(this.type);
    }

    public byte[] getCborBytes() {
        return this.data;
    }

    public Object decodeFromRegistry() throws InvalidCBORException {
        RegistryType registryType = this.getRegistryType();
        try {
            List dataItems = CborDecoder.decode((byte[])this.getCborBytes());
            DataItem item = (DataItem)dataItems.get(0);
            if (registryType == RegistryType.BYTES) {
                return ((ByteString)item).getBytes();
            }
            if (registryType == RegistryType.CRYPTO_SEED) {
                return CryptoSeed.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_BIP39) {
                return CryptoBip39.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_HDKEY) {
                return CryptoHDKey.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_KEYPATH) {
                return CryptoKeypath.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_COIN_INFO) {
                return CryptoCoinInfo.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_ECKEY) {
                return CryptoECKey.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_ADDRESS) {
                return CryptoAddress.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_OUTPUT) {
                return CryptoOutput.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_PSBT) {
                return CryptoPSBT.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_ACCOUNT) {
                return CryptoAccount.fromCbor(item);
            }
            if (registryType == RegistryType.CRYPTO_SSKR) {
                return CryptoSskr.fromCbor(item);
            }
            if (registryType == RegistryType.SEED) {
                return URSeed.fromCbor(item);
            }
            if (registryType == RegistryType.HDKEY) {
                return URHDKey.fromCbor(item);
            }
            if (registryType == RegistryType.KEYPATH) {
                return URKeypath.fromCbor(item);
            }
            if (registryType == RegistryType.COIN_INFO) {
                return URCoinInfo.fromCbor(item);
            }
            if (registryType == RegistryType.ECKEY) {
                return URECKey.fromCbor(item);
            }
            if (registryType == RegistryType.ADDRESS) {
                return URAddress.fromCbor(item);
            }
            if (registryType == RegistryType.OUTPUT_DESCRIPTOR) {
                return UROutputDescriptor.fromCbor(item);
            }
            if (registryType == RegistryType.PSBT) {
                return URPSBT.fromCbor(item);
            }
            if (registryType == RegistryType.ACCOUNT_DESCRIPTOR) {
                return URAccountDescriptor.fromCbor(item);
            }
            if (registryType == RegistryType.SSKR) {
                return URSSKR.fromCbor(item);
            }
        }
        catch (CborException e) {
            throw new InvalidCBORException(e.getMessage());
        }
        return null;
    }

    public byte[] toBytes() throws InvalidCBORException {
        try {
            List dataItems = CborDecoder.decode((byte[])this.getCborBytes());
            if (!(dataItems.get(0) instanceof ByteString)) {
                throw new IllegalArgumentException("First element of CBOR is not a byte string");
            }
            return ((ByteString)dataItems.get(0)).getBytes();
        }
        catch (CborException e) {
            throw new InvalidCBORException(e.getMessage());
        }
    }

    public static boolean isURType(String type) {
        for (char c : type.toCharArray()) {
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('0' <= c && c <= '9') {
                return true;
            }
            if (c != '-') continue;
            return true;
        }
        return false;
    }

    public static UR fromBytes(byte[] data) throws InvalidTypeException, InvalidCBORException {
        return UR.fromBytes(RegistryType.BYTES.toString(), data);
    }

    public static UR fromBytes(String type, byte[] data) throws InvalidTypeException, InvalidCBORException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new CborEncoder((OutputStream)baos).encode(new CborBuilder().add(data).build());
            byte[] cbor = baos.toByteArray();
            return new UR(type, cbor);
        }
        catch (CborException e) {
            throw new InvalidCBORException(e.getMessage());
        }
    }

    public String toString() {
        return UREncoder.encode(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UR ur = (UR)o;
        return this.type.equals(ur.type) && Arrays.equals(this.data, ur.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.type);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static class InvalidCBORException
    extends URException {
        public InvalidCBORException(String message) {
            super(message);
        }
    }

    public static class InvalidSequenceComponentException
    extends URException {
        public InvalidSequenceComponentException(String message) {
            super(message);
        }
    }

    public static class InvalidPathLengthException
    extends URException {
        public InvalidPathLengthException(String message) {
            super(message);
        }
    }

    public static class InvalidSchemeException
    extends URException {
        public InvalidSchemeException(String message) {
            super(message);
        }
    }

    public static class InvalidTypeException
    extends URException {
        public InvalidTypeException(String message) {
            super(message);
        }
    }

    public static class URException
    extends Exception {
        public URException(String message) {
            super(message);
        }
    }
}

