/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import co.nstant.in.cbor.CborException;
import com.sparrowwallet.hummingbird.Bytewords;
import com.sparrowwallet.hummingbird.ResultType;
import com.sparrowwallet.hummingbird.UR;
import com.sparrowwallet.hummingbird.fountain.FountainDecoder;
import com.sparrowwallet.hummingbird.fountain.FountainEncoder;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URDecoder {
    private static final Pattern SEQUENCE_COMPONENT_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    private final FountainDecoder fountainDecoder = new FountainDecoder();
    private String expectedType;
    private Result result;

    public int getExpectedPartCount() {
        return this.fountainDecoder.getExpectedPartCount();
    }

    public Set<Integer> getReceivedPartIndexes() {
        return this.fountainDecoder.getRecievedPartIndexes();
    }

    public Set<Integer> getLastPartIndexes() {
        return this.fountainDecoder.getLastPartIndexes();
    }

    public int getProcessedPartsCount() {
        return this.fountainDecoder.getProcessedPartsCount();
    }

    public double getEstimatedPercentComplete() {
        return this.fountainDecoder.getEstimatedPercentComplete();
    }

    public Result getResult() {
        return this.result;
    }

    public static UR decode(String string) throws UR.URException {
        ParsedURString parsedURString = URDecoder.parse(string);
        if (parsedURString.components.length < 1) {
            throw new UR.InvalidPathLengthException("Invalid path length");
        }
        String body = parsedURString.components[0];
        return URDecoder.decode(parsedURString.type, body);
    }

    public static UR decode(String type, String body) throws UR.InvalidTypeException {
        byte[] cbor = Bytewords.decode(body, Bytewords.Style.MINIMAL);
        return new UR(type, cbor);
    }

    public boolean receivePart(String string) {
        try {
            if (this.getResult() != null) {
                return false;
            }
            ParsedURString parsedURString = URDecoder.parse(string);
            if (!this.validatePart(parsedURString.type)) {
                return false;
            }
            if (parsedURString.components.length == 1) {
                String body = parsedURString.components[0];
                this.result = new Result(ResultType.SUCCESS, URDecoder.decode(parsedURString.type, body), null);
                return true;
            }
            if (parsedURString.components.length != 2) {
                throw new UR.InvalidPathLengthException("Invalid path length");
            }
            String seq = parsedURString.components[0];
            String fragment = parsedURString.components[1];
            Matcher matcher = SEQUENCE_COMPONENT_PATTERN.matcher(seq);
            if (matcher.matches()) {
                int seqNum = Integer.parseInt(matcher.group(1));
                int seqLen = Integer.parseInt(matcher.group(2));
                byte[] cbor = Bytewords.decode(fragment, Bytewords.Style.MINIMAL);
                FountainEncoder.Part part = FountainEncoder.Part.fromCborBytes(cbor);
                if ((long)seqNum != part.getSeqNum() || seqLen != part.getSeqLen()) {
                    return false;
                }
                if (!this.fountainDecoder.receivePart(part)) {
                    return false;
                }
                if (this.fountainDecoder.getResult() != null) {
                    if (this.fountainDecoder.getResult().type == ResultType.SUCCESS) {
                        this.result = new Result(ResultType.SUCCESS, new UR(parsedURString.type, this.fountainDecoder.getResult().data), null);
                    } else if (this.fountainDecoder.getResult().type == ResultType.FAILURE) {
                        this.result = new Result(ResultType.FAILURE, null, this.fountainDecoder.getResult().error);
                    }
                }
                return true;
            }
            throw new UR.InvalidSequenceComponentException("Invalid sequence " + seq);
        }
        catch (CborException | UR.URException e) {
            return false;
        }
    }

    private boolean validatePart(String type) {
        if (this.expectedType == null) {
            if (!UR.isURType(type)) {
                return false;
            }
        } else {
            return this.expectedType.equals(type);
        }
        this.expectedType = type;
        return true;
    }

    static ParsedURString parse(String string) throws UR.URException {
        String lowercased = string.toLowerCase();
        if (!lowercased.startsWith("ur:")) {
            throw new UR.InvalidSchemeException("Invalid scheme");
        }
        String path = lowercased.substring(3);
        String[] components = path.split("/");
        if (components.length <= 1) {
            throw new UR.InvalidPathLengthException("Invalid path length");
        }
        String type = components[0];
        if (!UR.isURType(type)) {
            throw new UR.InvalidTypeException("Invalid type: " + type);
        }
        return new ParsedURString(type, Arrays.copyOfRange(components, 1, components.length));
    }

    public static class Result {
        public final ResultType type;
        public final UR ur;
        public final String error;

        public Result(ResultType type, UR ur, String error) {
            this.type = type;
            this.ur = ur;
            this.error = error;
        }
    }

    private static class ParsedURString {
        public final String type;
        public final String[] components;

        public ParsedURString(String type, String[] components) {
            this.type = type;
            this.components = components;
        }
    }
}

