/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird;

import com.sparrowwallet.hummingbird.Bytewords;
import com.sparrowwallet.hummingbird.UR;
import com.sparrowwallet.hummingbird.fountain.FountainEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class UREncoder {
    private final UR ur;
    private final FountainEncoder fountainEncoder;

    public UREncoder(UR ur, int maxFragmentLen, int minFragmentLen, long firstSeqNum) {
        this.ur = ur;
        this.fountainEncoder = new FountainEncoder(ur.getCborBytes(), maxFragmentLen, minFragmentLen, firstSeqNum);
    }

    public boolean isComplete() {
        return this.fountainEncoder.isComplete();
    }

    public boolean isSinglePart() {
        return this.fountainEncoder.isSinglePart();
    }

    public String nextPart() {
        FountainEncoder.Part part = this.fountainEncoder.nextPart();
        if (this.isSinglePart()) {
            return UREncoder.encode(this.ur);
        }
        return UREncoder.encodePart(this.ur.getType(), part);
    }

    public long getSeqNum() {
        return this.fountainEncoder.getSeqNum();
    }

    public int getSeqLen() {
        return this.fountainEncoder.getSeqLen();
    }

    public List<Integer> getPartIndexes() {
        return this.fountainEncoder.getPartIndexes();
    }

    public static String encode(UR ur) {
        String encoded = Bytewords.encode(ur.getCborBytes(), Bytewords.Style.MINIMAL);
        return UREncoder.encodeUR(ur.getType(), encoded);
    }

    private static String encodeUR(String ... pathComponents) {
        return UREncoder.encodeURI("ur", pathComponents);
    }

    private static String encodeURI(String scheme, String ... pathComponents) {
        StringJoiner joiner = new StringJoiner("/");
        Arrays.stream(pathComponents).forEach(joiner::add);
        String path = joiner.toString();
        return scheme + ":" + path;
    }

    private static String encodePart(String type, FountainEncoder.Part part) {
        String seq = part.getSeqNum() + "-" + part.getSeqLen();
        String body = Bytewords.encode(part.toCborBytes(), Bytewords.Style.MINIMAL);
        return UREncoder.encodeUR(type, seq, body);
    }
}

