/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.fountain;

import com.sparrowwallet.hummingbird.ResultType;
import com.sparrowwallet.hummingbird.fountain.FountainEncoder;
import com.sparrowwallet.hummingbird.fountain.FountainUtils;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.CRC32;

public class FountainDecoder {
    private final Set<Integer> recievedPartIndexes = new TreeSet<Integer>();
    private Set<Integer> lastPartIndexes;
    private final Set<Integer> processedPartHashes = new HashSet<Integer>();
    private int processedPartsCount = 0;
    private Result result;
    private long checksum;
    private Set<Integer> expectedPartIndexes;
    private int expectedFragmentLen;
    private int expectedMessageLen;
    private long expectedChecksum;
    private final Map<List<Integer>, Part> simpleParts = new HashMap<List<Integer>, Part>();
    private Map<List<Integer>, Part> mixedParts = new HashMap<List<Integer>, Part>();
    private final List<Part> queuedParts = new ArrayList<Part>();

    public int getExpectedPartCount() {
        return this.expectedPartIndexes == null ? 0 : this.expectedPartIndexes.size();
    }

    public Set<Integer> getRecievedPartIndexes() {
        return this.recievedPartIndexes;
    }

    public Set<Integer> getLastPartIndexes() {
        return this.lastPartIndexes;
    }

    public int getProcessedPartsCount() {
        return this.processedPartsCount;
    }

    public double getEstimatedPercentComplete() {
        if (this.processedPartsCount == 0) {
            return 0.0;
        }
        double estimatedInputParts = (double)this.getExpectedPartCount() * 1.75;
        return Math.min(0.99, (double)this.processedPartsCount / estimatedInputParts);
    }

    public Result getResult() {
        return this.result;
    }

    public boolean receivePart(FountainEncoder.Part encoderPart) {
        if (this.result != null) {
            return false;
        }
        if (!this.validatePart(encoderPart)) {
            return false;
        }
        Part part = new Part(encoderPart);
        this.lastPartIndexes = new HashSet<Integer>(part.partIndexes);
        this.enqueue(part);
        while (this.result == null && !this.queuedParts.isEmpty()) {
            this.processQueueItem();
        }
        if (this.processedPartHashes.add(encoderPart.hashCode())) {
            ++this.processedPartsCount;
        }
        return true;
    }

    private void enqueue(Part part) {
        this.queuedParts.add(part);
    }

    private void printPartEnd() {
        int percent = (int)Math.round(this.getEstimatedPercentComplete() * 100.0);
        System.out.println("processed: " + this.processedPartsCount + " expected: " + this.getExpectedPartCount() + " received: " + this.recievedPartIndexes.size() + " percent: " + percent + "%");
    }

    private void printPart(Part part) {
        List sorted = part.partIndexes.stream().sorted().collect(Collectors.toList());
        System.out.println("part indexes: " + sorted);
    }

    private void printState() {
        List sortedReceived = this.recievedPartIndexes.stream().sorted().collect(Collectors.toList());
        List mixed = this.mixedParts.keySet().stream().map(list -> {
            list.sort(Comparator.naturalOrder());
            return list;
        }).collect(Collectors.toList());
        System.out.println("parts: " + this.getExpectedPartCount() + ", received: " + sortedReceived + ", mixed: " + mixed + ", queued: " + this.queuedParts.size() + ", result: " + this.result);
    }

    private void processQueueItem() {
        Part part = this.queuedParts.remove(0);
        if (part.isSimple()) {
            this.processSimplePart(part);
        } else {
            this.processMixedPart(part);
        }
    }

    private void reduceMixed(Part by) {
        List<Part> reducedParts = this.mixedParts.values().stream().map(part -> this.reducePart((Part)part, by)).collect(Collectors.toList());
        HashMap<List<Integer>, Part> newMixed = new HashMap<List<Integer>, Part>();
        reducedParts.forEach(reducedPart -> {
            if (reducedPart.isSimple()) {
                this.enqueue((Part)reducedPart);
            } else {
                newMixed.put(reducedPart.partIndexes, (Part)reducedPart);
            }
        });
        this.mixedParts = newMixed;
    }

    private Part reducePart(Part a, Part b) {
        if (a.partIndexes.containsAll(b.partIndexes)) {
            ArrayList<Integer> newIndexes = new ArrayList<Integer>(a.partIndexes);
            newIndexes.removeAll(b.partIndexes);
            byte[] newdata = FountainEncoder.xor(a.data, b.data);
            return new Part(newIndexes, newdata);
        }
        return a;
    }

    private void processSimplePart(Part part) {
        Integer fragmentIndex = part.partIndexes.get(0);
        if (this.recievedPartIndexes.contains(fragmentIndex)) {
            return;
        }
        this.simpleParts.put(part.partIndexes, part);
        this.recievedPartIndexes.add(fragmentIndex);
        if (this.recievedPartIndexes.equals(this.expectedPartIndexes)) {
            List sortedParts = this.simpleParts.values().stream().sorted(Comparator.comparingInt(rec$ -> ((Part)rec$).getIndex())).collect(Collectors.toList());
            List<byte[]> fragments = sortedParts.stream().map(part1 -> part1.data).collect(Collectors.toList());
            byte[] message = FountainDecoder.joinFragments(fragments, this.expectedMessageLen);
            CRC32 crc32 = new CRC32();
            crc32.update(message);
            this.checksum = crc32.getValue();
            this.result = this.checksum == this.expectedChecksum ? new Result(ResultType.SUCCESS, message, null) : new Result(ResultType.FAILURE, null, "Invalid checksum");
        } else {
            this.reduceMixed(part);
        }
    }

    private void processMixedPart(Part part) {
        if (this.mixedParts.containsKey(part.partIndexes)) {
            return;
        }
        ArrayList<Part> allParts = new ArrayList<Part>(this.simpleParts.values());
        allParts.addAll(this.mixedParts.values());
        Part p = allParts.stream().reduce(part, this::reducePart);
        if (p.isSimple()) {
            this.enqueue(p);
        } else {
            this.reduceMixed(p);
            this.mixedParts.put(p.partIndexes, p);
        }
    }

    private boolean validatePart(FountainEncoder.Part part) {
        if (this.expectedPartIndexes == null) {
            this.expectedPartIndexes = IntStream.range(0, part.getSeqLen()).boxed().collect(Collectors.toSet());
            this.expectedMessageLen = part.getMessageLen();
            this.expectedChecksum = part.getChecksum();
            this.expectedFragmentLen = part.getData().length;
            return true;
        }
        return this.getExpectedPartCount() == part.getSeqLen() && this.expectedMessageLen == part.getMessageLen() && this.expectedChecksum == part.getChecksum() && this.expectedFragmentLen == part.getData().length;
    }

    static byte[] joinFragments(List<byte[]> fragments, int messageLen) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] fragment : fragments) {
            baos.write(fragment, 0, fragment.length);
        }
        byte[] message = baos.toByteArray();
        byte[] unpaddedMessage = new byte[messageLen];
        System.arraycopy(message, 0, unpaddedMessage, 0, messageLen);
        return unpaddedMessage;
    }

    public static class Result {
        public final ResultType type;
        public final byte[] data;
        public final String error;

        public Result(ResultType type, byte[] data, String error) {
            this.type = type;
            this.data = data;
            this.error = error;
        }
    }

    private static class Part {
        private final List<Integer> partIndexes;
        private final byte[] data;

        private int getIndex() {
            return this.partIndexes.get(0);
        }

        Part(FountainEncoder.Part part) {
            this.partIndexes = FountainUtils.chooseFragments(part.getSeqNum(), part.getSeqLen(), part.getChecksum());
            this.data = part.getData();
        }

        Part(List<Integer> indexes, byte[] data) {
            this.partIndexes = indexes;
            this.data = data;
        }

        public boolean isSimple() {
            return this.partIndexes.size() == 1;
        }
    }
}

