/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.fountain;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.fountain.FountainUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;

public class FountainEncoder {
    private final int messageLen;
    private final long checksum;
    private final int fragmentLen;
    private final List<byte[]> fragments;
    private final int seqLen;
    private List<Integer> partIndexes;
    private long seqNum;

    public FountainEncoder(byte[] message, int maxFragmentLen, int minFragmentLen, long firstSeqNum) {
        if (message.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Message too long");
        }
        this.messageLen = message.length;
        CRC32 crc32 = new CRC32();
        crc32.update(message);
        this.checksum = crc32.getValue();
        this.fragmentLen = FountainEncoder.findNominalFragmentLength(this.messageLen, minFragmentLen, maxFragmentLen);
        this.fragments = FountainEncoder.partitionMessage(message, this.fragmentLen);
        this.seqLen = this.fragments.size();
        this.seqNum = firstSeqNum;
    }

    public Part nextPart() {
        ++this.seqNum;
        this.partIndexes = FountainUtils.chooseFragments(this.seqNum, this.seqLen, this.checksum);
        byte[] mixed = this.mix(this.partIndexes);
        return new Part(this.seqNum, this.seqLen, this.messageLen, this.checksum, mixed);
    }

    private byte[] mix(List<Integer> partIndexes) {
        return partIndexes.stream().reduce(new byte[this.fragmentLen], (result, index) -> FountainEncoder.xor(this.fragments.get((int)index), result), FountainEncoder::xor);
    }

    public static byte[] xor(byte[] a, byte[] b) {
        byte[] result = new byte[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(a[i] ^ b[i]);
        }
        return result;
    }

    public boolean isComplete() {
        return this.seqNum >= (long)this.seqLen;
    }

    public boolean isSinglePart() {
        return this.seqLen == 1;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public int getSeqLen() {
        return this.seqLen;
    }

    public List<Integer> getPartIndexes() {
        return this.partIndexes;
    }

    static List<byte[]> partitionMessage(byte[] message, int fragmentLen) {
        int fragmentCount = (int)Math.ceil((double)message.length / (double)fragmentLen);
        ArrayList<byte[]> fragments = new ArrayList<byte[]>();
        int start = 0;
        for (int i = 0; i < fragmentCount; ++i) {
            fragments.add(Arrays.copyOfRange(message, start, start + fragmentLen));
            start += fragmentLen;
        }
        return fragments;
    }

    static int findNominalFragmentLength(int messageLen, int minFragmentLen, int maxFragmentLen) {
        int maxFragmentCount = Math.max(1, messageLen / minFragmentLen);
        int fragmentLen = 0;
        for (int fragmentCount = 1; fragmentCount <= maxFragmentCount && (fragmentLen = (int)Math.ceil((double)messageLen / (double)fragmentCount)) > maxFragmentLen; ++fragmentCount) {
        }
        return fragmentLen;
    }

    public static class Part {
        private final long seqNum;
        private final int seqLen;
        private final int messageLen;
        private final long checksum;
        private final byte[] data;

        public Part(long seqNum, int seqLen, int messageLen, long checksum, byte[] data) {
            this.seqNum = seqNum;
            this.seqLen = seqLen;
            this.messageLen = messageLen;
            this.checksum = checksum;
            this.data = data;
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public int getSeqLen() {
            return this.seqLen;
        }

        public int getMessageLen() {
            return this.messageLen;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public byte[] getData() {
            return this.data;
        }

        public byte[] toCborBytes() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new CborEncoder((OutputStream)baos).encode(((CborBuilder)new CborBuilder().addArray().add((DataItem)new UnsignedInteger(this.seqNum)).add((DataItem)new UnsignedInteger((long)this.seqLen)).add((DataItem)new UnsignedInteger((long)this.messageLen)).add((DataItem)new UnsignedInteger(this.checksum)).add(this.data).end()).build());
                return baos.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static Part fromCborBytes(byte[] cborData) throws CborException {
            ByteArrayInputStream bais = new ByteArrayInputStream(cborData);
            List arrayDataItems = new CborDecoder((InputStream)bais).decode();
            Array array = (Array)arrayDataItems.get(0);
            List dataItems = array.getDataItems();
            UnsignedInteger seqNum = (UnsignedInteger)dataItems.get(0);
            UnsignedInteger seqLen = (UnsignedInteger)dataItems.get(1);
            UnsignedInteger messageLen = (UnsignedInteger)dataItems.get(2);
            UnsignedInteger checksum = (UnsignedInteger)dataItems.get(3);
            ByteString data = (ByteString)dataItems.get(4);
            return new Part(seqNum.getValue().longValue(), seqLen.getValue().intValue(), messageLen.getValue().intValue(), checksum.getValue().longValue(), data.getBytes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Part part = (Part)o;
            if (this.seqNum != part.seqNum) {
                return false;
            }
            if (this.seqLen != part.seqLen) {
                return false;
            }
            if (this.messageLen != part.messageLen) {
                return false;
            }
            if (this.checksum != part.checksum) {
                return false;
            }
            return Arrays.equals(this.data, part.data);
        }

        public int hashCode() {
            int result = (int)(this.seqNum ^ this.seqNum >>> 32);
            result = 31 * result + this.seqLen;
            result = 31 * result + this.messageLen;
            result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }
}

