/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.fountain;

import com.sparrowwallet.hummingbird.fountain.RandomSampler;
import com.sparrowwallet.hummingbird.fountain.RandomXoshiro256StarStar;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FountainUtils {
    static List<Integer> chooseFragments(long seqNum, int seqLen, long checkSum) {
        if (seqNum <= (long)seqLen) {
            return Collections.singletonList((int)seqNum - 1);
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putInt((int)seqNum);
        buffer.putInt((int)checkSum);
        RandomXoshiro256StarStar rng = new RandomXoshiro256StarStar(buffer.array());
        int degree = FountainUtils.chooseDegree(seqLen, rng);
        List<Integer> indexes = IntStream.range(0, seqLen).boxed().collect(Collectors.toList());
        List<Integer> shuffledIndexes = FountainUtils.shuffled(indexes, rng);
        return new ArrayList<Integer>(shuffledIndexes.subList(0, degree));
    }

    static int chooseDegree(int seqLen, RandomXoshiro256StarStar rng) {
        List<Double> degreeProbabilties = IntStream.range(1, seqLen + 1).mapToObj(i -> 1.0 / (double)i).collect(Collectors.toList());
        RandomSampler randomSampler = new RandomSampler(degreeProbabilties);
        return randomSampler.next(rng) + 1;
    }

    static List<Integer> shuffled(List<Integer> indexes, RandomXoshiro256StarStar rng) {
        ArrayList<Integer> remaining = new ArrayList<Integer>(indexes);
        ArrayList<Integer> shuffled = new ArrayList<Integer>(indexes.size());
        while (!remaining.isEmpty()) {
            int index = rng.nextInt(0, remaining.size());
            Integer item = (Integer)remaining.remove(index);
            shuffled.add(item);
        }
        return shuffled;
    }
}

