/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.fountain;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class RandomSampler {
    private final double[] probs;
    private final int[] aliases;

    public RandomSampler(List<Double> probabilities) {
        if (probabilities.stream().anyMatch(prob -> prob < 0.0)) {
            throw new IllegalArgumentException("Probabilties must be > 0");
        }
        double sum = probabilities.stream().reduce(0.0, Double::sum);
        int n = probabilities.size();
        List P = probabilities.stream().map(prob -> prob * (double)n / sum).collect(Collectors.toList());
        ArrayList<Integer> S = new ArrayList<Integer>();
        ArrayList<Integer> L = new ArrayList<Integer>();
        for (int i = n - 1; i >= 0; --i) {
            if ((Double)P.get(i) < 1.0) {
                S.add(i);
                continue;
            }
            L.add(i);
        }
        double[] probs = new double[n];
        int[] aliases = new int[n];
        while (!S.isEmpty() && !L.isEmpty()) {
            int a = (Integer)S.remove(S.size() - 1);
            int g = (Integer)L.remove(L.size() - 1);
            probs[a] = (Double)P.get(a);
            aliases[a] = g;
            P.set(g, (Double)P.get(g) + (Double)P.get(a) - 1.0);
            if ((Double)P.get(g) < 1.0) {
                S.add(g);
                continue;
            }
            L.add(g);
        }
        while (!L.isEmpty()) {
            probs[((Integer)L.remove((int)(L.size() - 1))).intValue()] = 1.0;
        }
        while (!S.isEmpty()) {
            probs[((Integer)S.remove((int)(S.size() - 1))).intValue()] = 1.0;
        }
        this.probs = probs;
        this.aliases = aliases;
    }

    public int next(Random random) {
        int n;
        int i;
        double r1 = random.nextDouble();
        double r2 = random.nextDouble();
        return r2 < this.probs[i = (int)((double)(n = this.probs.length) * r1)] ? i : this.aliases[i];
    }
}

