/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoOutput;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CryptoAccount
extends RegistryItem {
    public static final long MASTER_FINGERPRINT_KEY = 1L;
    public static final long OUTPUT_DESCRIPTORS_KEY = 2L;
    private final byte[] masterFingerprint;
    private final List<CryptoOutput> outputDescriptors;

    public CryptoAccount(byte[] masterFingerprint, List<CryptoOutput> outputDescriptors) {
        this.masterFingerprint = Arrays.copyOfRange(masterFingerprint, masterFingerprint.length - 4, masterFingerprint.length);
        this.outputDescriptors = outputDescriptors;
    }

    public byte[] getMasterFingerprint() {
        return this.masterFingerprint;
    }

    public List<CryptoOutput> getOutputDescriptors() {
        return this.outputDescriptors;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger(new BigInteger(1, this.masterFingerprint)));
        Array array = new Array();
        for (CryptoOutput cryptoOutput : this.outputDescriptors) {
            DataItem tag;
            DataItem dataItem = cryptoOutput.toCbor();
            Object object = tag = dataItem.getTag() == null ? dataItem : dataItem.getTag();
            while (tag.getTag() != null) {
                tag = tag.getTag();
            }
            tag.setTag((long)RegistryType.CRYPTO_OUTPUT.getTag().intValue());
            array.add(dataItem);
        }
        map.put((DataItem)new UnsignedInteger(2L), (DataItem)array);
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_ACCOUNT;
    }

    public static CryptoAccount fromCbor(DataItem cbor) {
        Map cryptoAccountMap = (Map)cbor;
        UnsignedInteger uintMasterFingerprint = (UnsignedInteger)cryptoAccountMap.get((DataItem)new UnsignedInteger(1L));
        byte[] masterFingerprint = CryptoAccount.bigIntegerToBytes(uintMasterFingerprint.getValue(), 4);
        Array outputDescriptors = (Array)cryptoAccountMap.get((DataItem)new UnsignedInteger(2L));
        ArrayList<CryptoOutput> cryptoOutputs = new ArrayList<CryptoOutput>(outputDescriptors.getDataItems().size());
        for (DataItem item : outputDescriptors.getDataItems()) {
            cryptoOutputs.add(CryptoOutput.fromCbor(item));
        }
        return new CryptoAccount(masterFingerprint, cryptoOutputs);
    }
}

