/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoCoinInfo;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;

public class CryptoAddress
extends RegistryItem {
    public static final long INFO = 1L;
    public static final long TYPE = 2L;
    public static final long DATA = 3L;
    private final CryptoCoinInfo info;
    private final Type type;
    private final byte[] data;

    public CryptoAddress(CryptoCoinInfo info, Type type, byte[] data) {
        this.info = info;
        this.type = type;
        this.data = data;
    }

    public CryptoCoinInfo getInfo() {
        return this.info;
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        if (this.info != null) {
            map.put((DataItem)new UnsignedInteger(1L), this.info.toCbor());
        }
        if (this.type != null) {
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger((long)this.type.ordinal()));
        }
        map.put((DataItem)new UnsignedInteger(3L), (DataItem)new ByteString(this.data));
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_ADDRESS;
    }

    public static CryptoAddress fromCbor(DataItem item) {
        CryptoCoinInfo info = null;
        Type type = null;
        byte[] data = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                info = CryptoCoinInfo.fromCbor(map.get(key));
                continue;
            }
            if ((long)intKey == 2L) {
                type = Type.values()[((UnsignedInteger)map.get(key)).getValue().intValue()];
                continue;
            }
            if ((long)intKey != 3L) continue;
            data = ((ByteString)map.get(key)).getBytes();
        }
        if (data == null) {
            throw new IllegalStateException("Data is null");
        }
        return new CryptoAddress(info, type, data);
    }

    public static enum Type {
        P2PKH,
        P2SH,
        P2WPKH;

    }
}

