/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.util.ArrayList;
import java.util.List;

public class CryptoBip39
extends RegistryItem {
    public static final long WORDS = 1L;
    public static final long LANG = 2L;
    private final List<String> words;
    private final String language;

    public CryptoBip39(List<String> words, String language) {
        this.words = words;
        this.language = language;
    }

    public List<String> getWords() {
        return this.words;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        Array wordsArray = new Array();
        for (String word : this.words) {
            wordsArray.add((DataItem)new UnicodeString(word));
        }
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)wordsArray);
        if (this.language != null) {
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnicodeString(this.language));
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_BIP39;
    }

    public static CryptoBip39 fromCbor(DataItem item) {
        ArrayList<String> words = new ArrayList<String>();
        String language = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                Array wordsArray = (Array)map.get(key);
                for (DataItem wordItem : wordsArray.getDataItems()) {
                    words.add(((UnicodeString)wordItem).getString());
                }
                continue;
            }
            if ((long)intKey != 2L) continue;
            language = ((UnicodeString)map.get(key)).getString();
        }
        if (words.isEmpty()) {
            throw new IllegalStateException("No BIP39 words");
        }
        return new CryptoBip39(words, language);
    }
}

