/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;

public class CryptoCoinInfo
extends RegistryItem {
    public static final int TYPE_KEY = 1;
    public static final int NETWORK_KEY = 2;
    private final Integer type;
    private final Integer network;

    public CryptoCoinInfo(Integer type, Integer network) {
        if (network.equals(Network.GOERLI.networkValue) && !type.equals(Type.ETHEREUM.typeValue)) {
            throw new IllegalArgumentException("Goerli network can only be selected for Ethereum");
        }
        this.type = type;
        this.network = network;
    }

    public CryptoCoinInfo(Type type, Network network) {
        if (network == Network.GOERLI && type != Type.ETHEREUM) {
            throw new IllegalArgumentException("Goerli network can only be selected for Ethereum");
        }
        this.type = type != null ? type.typeValue : null;
        this.network = network != null ? network.networkValue : null;
    }

    public Type getType() {
        return this.type == null ? Type.BITCOIN : Type.getTypeFromValue(this.type);
    }

    public Network getNetwork() {
        return this.network == null ? Network.MAINNET : Network.getNetworkFromValue(this.network);
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        if (this.type != null) {
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger((long)this.type.intValue()));
        }
        if (this.network != null) {
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger((long)this.network.intValue()));
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_COIN_INFO;
    }

    public static CryptoCoinInfo fromCbor(DataItem item) {
        Integer type = null;
        Integer network = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if (intKey == 1) {
                type = ((UnsignedInteger)map.get(key)).getValue().intValue();
                continue;
            }
            if (intKey != 2) continue;
            network = ((UnsignedInteger)map.get(key)).getValue().intValue();
        }
        return new CryptoCoinInfo(type, network);
    }

    public static enum Network {
        MAINNET(0),
        TESTNET(1),
        GOERLI(4);

        Integer networkValue;

        private Network(Integer networkValue) {
            this.networkValue = networkValue;
        }

        static Network getNetworkFromValue(int value) {
            for (int i = 0; i < Network.values().length; ++i) {
                Network current = Network.values()[i];
                if (value != current.networkValue) continue;
                return current;
            }
            return null;
        }
    }

    public static enum Type {
        BITCOIN(0),
        ETHEREUM(60);

        Integer typeValue;

        private Type(Integer typeValue) {
            this.typeValue = typeValue;
        }

        static Type getTypeFromValue(int value) {
            for (int i = 0; i < Type.values().length; ++i) {
                Type current = Type.values()[i];
                if (value != current.typeValue) continue;
                return current;
            }
            return null;
        }
    }
}

