/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;

public class CryptoECKey
extends RegistryItem {
    public static final long CURVE = 1L;
    public static final long PRIVATE = 2L;
    public static final long DATA = 3L;
    private final Integer curve;
    private final Boolean privateKey;
    private final byte[] data;

    public CryptoECKey(Integer curve, Boolean privateKey, byte[] data) {
        this.curve = curve;
        this.privateKey = privateKey;
        this.data = data;
    }

    public int getCurve() {
        return this.curve == null ? 0 : this.curve;
    }

    public boolean isPrivateKey() {
        return this.privateKey == null ? false : this.privateKey;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        if (this.curve != null) {
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger((long)this.curve.intValue()));
        }
        if (this.privateKey != null) {
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)(this.privateKey != false ? SimpleValue.TRUE : SimpleValue.FALSE));
        }
        map.put((DataItem)new UnsignedInteger(3L), (DataItem)new ByteString(this.data));
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_ECKEY;
    }

    public static CryptoECKey fromCbor(DataItem item) {
        Integer curve = null;
        Boolean privateKey = null;
        byte[] data = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                curve = ((UnsignedInteger)map.get(key)).getValue().intValue();
                continue;
            }
            if ((long)intKey == 2L) {
                privateKey = map.get(key) == SimpleValue.TRUE;
                continue;
            }
            if ((long)intKey != 3L) continue;
            data = ((ByteString)map.get(key)).getBytes();
        }
        if (data == null) {
            throw new IllegalStateException("Data is null");
        }
        return new CryptoECKey(curve, privateKey, data);
    }
}

