/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoCoinInfo;
import com.sparrowwallet.hummingbird.registry.CryptoKeypath;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.math.BigInteger;
import java.util.Arrays;

public class CryptoHDKey
extends RegistryItem {
    public static final int IS_MASTER_KEY = 1;
    public static final int IS_PRIVATE_KEY = 2;
    public static final int KEY_DATA_KEY = 3;
    public static final int CHAIN_CODE_KEY = 4;
    public static final int USE_INFO_KEY = 5;
    public static final int ORIGIN_KEY = 6;
    public static final int CHILDREN_KEY = 7;
    public static final int PARENT_FINGERPRINT_KEY = 8;
    public static final int NAME_KEY = 9;
    public static final int NOTE_KEY = 10;
    private final boolean master;
    private final Boolean privateKey;
    private final byte[] key;
    private final byte[] chainCode;
    private final CryptoCoinInfo useInfo;
    private final CryptoKeypath origin;
    private final CryptoKeypath children;
    private final byte[] parentFingerprint;
    private final String name;
    private final String note;

    public CryptoHDKey(byte[] key, byte[] chainCode) {
        this.master = true;
        this.privateKey = true;
        this.key = key;
        this.chainCode = chainCode;
        this.useInfo = null;
        this.origin = null;
        this.children = null;
        this.parentFingerprint = null;
        this.name = null;
        this.note = null;
    }

    public CryptoHDKey(Boolean privateKey, byte[] key, byte[] chainCode, CryptoCoinInfo useInfo, CryptoKeypath origin, CryptoKeypath children, byte[] parentFingerprint) {
        this(privateKey, key, chainCode, useInfo, origin, children, parentFingerprint, null, null);
    }

    public CryptoHDKey(Boolean privateKey, byte[] key, byte[] chainCode, CryptoCoinInfo useInfo, CryptoKeypath origin, CryptoKeypath children, byte[] parentFingerprint, String name, String note) {
        this.master = false;
        this.privateKey = privateKey;
        this.key = key;
        this.chainCode = chainCode;
        this.useInfo = useInfo;
        this.origin = origin;
        this.children = children;
        this.parentFingerprint = parentFingerprint == null ? null : Arrays.copyOfRange(parentFingerprint, parentFingerprint.length - 4, parentFingerprint.length);
        this.name = name;
        this.note = note;
    }

    public boolean isMaster() {
        return this.master;
    }

    public boolean isPrivateKey() {
        return this.privateKey == null ? false : this.privateKey;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public CryptoCoinInfo getUseInfo() {
        return this.useInfo;
    }

    public CryptoKeypath getOrigin() {
        return this.origin;
    }

    public CryptoKeypath getChildren() {
        return this.children;
    }

    public byte[] getParentFingerprint() {
        return this.parentFingerprint;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        if (this.master) {
            map.put((DataItem)new UnsignedInteger(1L), (DataItem)SimpleValue.TRUE);
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)new ByteString(this.key));
            map.put((DataItem)new UnsignedInteger(4L), (DataItem)new ByteString(this.chainCode));
        } else {
            if (this.privateKey != null) {
                map.put((DataItem)new UnsignedInteger(2L), (DataItem)(this.privateKey != false ? SimpleValue.TRUE : SimpleValue.FALSE));
            }
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)new ByteString(this.key));
            if (this.chainCode != null) {
                map.put((DataItem)new UnsignedInteger(4L), (DataItem)new ByteString(this.chainCode));
            }
            if (this.useInfo != null) {
                DataItem useInfoItem = this.useInfo.toCbor();
                useInfoItem.setTag((long)RegistryType.CRYPTO_COIN_INFO.getTag().intValue());
                map.put((DataItem)new UnsignedInteger(5L), useInfoItem);
            }
            if (this.origin != null) {
                DataItem originItem = this.origin.toCbor();
                originItem.setTag((long)RegistryType.CRYPTO_KEYPATH.getTag().intValue());
                map.put((DataItem)new UnsignedInteger(6L), originItem);
            }
            if (this.children != null) {
                DataItem childrenItem = this.children.toCbor();
                childrenItem.setTag((long)RegistryType.CRYPTO_KEYPATH.getTag().intValue());
                map.put((DataItem)new UnsignedInteger(7L), childrenItem);
            }
            if (this.parentFingerprint != null) {
                map.put((DataItem)new UnsignedInteger(8L), (DataItem)new UnsignedInteger(new BigInteger(1, this.parentFingerprint)));
            }
            if (this.name != null) {
                map.put((DataItem)new UnsignedInteger(9L), (DataItem)new UnicodeString(this.name));
            }
            if (this.note != null) {
                map.put((DataItem)new UnsignedInteger(10L), (DataItem)new UnicodeString(this.note));
            }
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_HDKEY;
    }

    public static CryptoHDKey fromCbor(DataItem item) {
        boolean isMasterKey = false;
        Boolean isPrivateKey = null;
        byte[] keyData = null;
        byte[] chainCode = null;
        CryptoCoinInfo useInfo = null;
        CryptoKeypath origin = null;
        CryptoKeypath children = null;
        byte[] parentFingerprint = null;
        String name = null;
        String note = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if (intKey == 1) {
                isMasterKey = map.get((DataItem)uintKey) == SimpleValue.TRUE;
                continue;
            }
            if (intKey == 2) {
                isPrivateKey = map.get((DataItem)uintKey) == SimpleValue.TRUE;
                continue;
            }
            if (intKey == 3) {
                keyData = ((ByteString)map.get((DataItem)uintKey)).getBytes();
                continue;
            }
            if (intKey == 4) {
                chainCode = ((ByteString)map.get((DataItem)uintKey)).getBytes();
                continue;
            }
            if (intKey == 5) {
                useInfo = CryptoCoinInfo.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 6) {
                origin = CryptoKeypath.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 7) {
                children = CryptoKeypath.fromCbor(map.get((DataItem)uintKey));
                continue;
            }
            if (intKey == 8) {
                parentFingerprint = CryptoHDKey.bigIntegerToBytes(((UnsignedInteger)map.get((DataItem)uintKey)).getValue(), 4);
                continue;
            }
            if (intKey == 9) {
                name = ((UnicodeString)map.get((DataItem)uintKey)).getString();
                continue;
            }
            if (intKey != 10) continue;
            note = ((UnicodeString)map.get((DataItem)uintKey)).getString();
        }
        if (keyData == null) {
            throw new IllegalStateException("Key data is null");
        }
        if (isMasterKey) {
            if (chainCode == null) {
                throw new IllegalStateException("Chain code data is null");
            }
            return new CryptoHDKey(keyData, chainCode);
        }
        return new CryptoHDKey(isPrivateKey, keyData, chainCode, useInfo, origin, children, parentFingerprint, name, note);
    }
}

