/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.pathcomponent.PathComponent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class CryptoKeypath
extends RegistryItem {
    public static final int COMPONENTS_KEY = 1;
    public static final int SOURCE_FINGERPRINT_KEY = 2;
    public static final int DEPTH_KEY = 3;
    private final List<PathComponent> components;
    private final byte[] sourceFingerprint;
    private final Integer depth;

    public CryptoKeypath(List<PathComponent> components, byte[] sourceFingerprint) {
        this(components, sourceFingerprint, null);
    }

    public CryptoKeypath(List<PathComponent> components, byte[] sourceFingerprint, Integer depth) {
        this.components = components;
        this.sourceFingerprint = sourceFingerprint == null ? null : Arrays.copyOfRange(sourceFingerprint, sourceFingerprint.length - 4, sourceFingerprint.length);
        this.depth = depth;
    }

    public List<PathComponent> getComponents() {
        return this.components;
    }

    public String getPath() {
        if (this.components.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner("/");
        for (PathComponent component : this.components) {
            joiner.add(component.toString());
        }
        return joiner.toString();
    }

    public byte[] getSourceFingerprint() {
        return this.sourceFingerprint;
    }

    public Integer getDepth() {
        return this.depth;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), PathComponent.toCbor(this.components));
        if (this.sourceFingerprint != null) {
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger(new BigInteger(1, this.sourceFingerprint)));
        }
        if (this.depth != null) {
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnsignedInteger((long)this.depth.intValue()));
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_KEYPATH;
    }

    public static CryptoKeypath fromCbor(DataItem item) {
        List<PathComponent> components = new ArrayList<PathComponent>();
        byte[] sourceFingerprint = null;
        Integer depth = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if (intKey == 1) {
                components = PathComponent.fromCbor(map.get(key));
                continue;
            }
            if (intKey == 2) {
                sourceFingerprint = CryptoKeypath.bigIntegerToBytes(((UnsignedInteger)map.get(key)).getValue(), 4);
                continue;
            }
            if (intKey != 3) continue;
            depth = ((UnsignedInteger)map.get(key)).getValue().intValue();
        }
        return new CryptoKeypath(components, sourceFingerprint, depth);
    }
}

