/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Tag;
import com.sparrowwallet.hummingbird.registry.CryptoECKey;
import com.sparrowwallet.hummingbird.registry.CryptoHDKey;
import com.sparrowwallet.hummingbird.registry.MultiKey;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.ScriptExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CryptoOutput
extends RegistryItem {
    private final List<ScriptExpression> scriptExpressions;
    private final CryptoECKey ecKey;
    private final CryptoHDKey hdKey;
    private final MultiKey multiKey;

    public CryptoOutput(List<ScriptExpression> scriptExpressions, CryptoECKey ecKey) {
        this.scriptExpressions = scriptExpressions;
        this.ecKey = ecKey;
        this.hdKey = null;
        this.multiKey = null;
    }

    public CryptoOutput(List<ScriptExpression> scriptExpressions, CryptoHDKey hdKey) {
        this.scriptExpressions = scriptExpressions;
        this.ecKey = null;
        this.hdKey = hdKey;
        this.multiKey = null;
    }

    public CryptoOutput(List<ScriptExpression> scriptExpressions, MultiKey multiKey) {
        this.scriptExpressions = scriptExpressions;
        this.ecKey = null;
        this.hdKey = null;
        this.multiKey = multiKey;
    }

    public List<ScriptExpression> getScriptExpressions() {
        return this.scriptExpressions;
    }

    public CryptoECKey getEcKey() {
        return this.ecKey;
    }

    public CryptoHDKey getHdKey() {
        return this.hdKey;
    }

    public MultiKey getMultiKey() {
        return this.multiKey;
    }

    @Override
    public DataItem toCbor() {
        DataItem item = null;
        if (this.multiKey != null) {
            item = this.multiKey.toCbor();
        } else if (this.ecKey != null) {
            item = this.ecKey.toCbor();
            item.setTag((long)RegistryType.CRYPTO_ECKEY.getTag().intValue());
        } else if (this.hdKey != null) {
            item = this.hdKey.toCbor();
            item.setTag((long)RegistryType.CRYPTO_HDKEY.getTag().intValue());
        }
        Tag tag = item.getTag();
        for (int i = this.scriptExpressions.size() - 1; i >= 0; --i) {
            Tag newTag = new Tag((long)this.scriptExpressions.get(i).getTagValue());
            if (tag == null) {
                item.setTag(newTag);
            } else {
                tag.setTag(newTag);
            }
            tag = newTag;
        }
        return item;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_OUTPUT;
    }

    public static CryptoOutput fromCbor(DataItem cbor) {
        ArrayList<ScriptExpression> expressions = new ArrayList<ScriptExpression>();
        Tag tag = cbor.getTag();
        do {
            if (tag.getValue() == (long)RegistryType.CRYPTO_HDKEY.getTag().intValue() || tag.getValue() == (long)RegistryType.CRYPTO_ECKEY.getTag().intValue() || tag.getValue() == (long)RegistryType.CRYPTO_OUTPUT.getTag().intValue()) continue;
            expressions.add(ScriptExpression.fromTagValue(tag.getValue()));
        } while ((tag = tag.getTag()) != null);
        boolean isMultiKey = expressions.get(0) == ScriptExpression.MULTISIG || expressions.get(0) == ScriptExpression.SORTED_MULTISIG;
        Collections.reverse(expressions);
        Map map = (Map)cbor;
        if (isMultiKey) {
            MultiKey multiKey = MultiKey.fromCbor((DataItem)map);
            return new CryptoOutput(expressions, multiKey);
        }
        if (cbor.getTag().getValue() == (long)RegistryType.CRYPTO_ECKEY.getTag().intValue()) {
            CryptoECKey cryptoECKey = CryptoECKey.fromCbor((DataItem)map);
            return new CryptoOutput(expressions, cryptoECKey);
        }
        if (cbor.getTag().getValue() == (long)RegistryType.CRYPTO_HDKEY.getTag().intValue()) {
            CryptoHDKey cryptoHDKey = CryptoHDKey.fromCbor((DataItem)map);
            return new CryptoOutput(expressions, cryptoHDKey);
        }
        throw new IllegalStateException("Unknown tag for data item: " + cbor.getTag().getValue());
    }
}

