/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;

public class CryptoPSBT
extends RegistryItem {
    private final byte[] psbt;

    public CryptoPSBT(byte[] psbt) {
        this.psbt = psbt;
    }

    public byte[] getPsbt() {
        return this.psbt;
    }

    @Override
    public DataItem toCbor() {
        return new ByteString(this.psbt);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_PSBT;
    }

    public static CryptoPSBT fromCbor(DataItem item) {
        return new CryptoPSBT(((ByteString)item).getBytes());
    }
}

