/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.util.Date;

public class CryptoSeed
extends RegistryItem {
    public static final long PAYLOAD_KEY = 1L;
    public static final long BIRTHDATE_KEY = 2L;
    public static final long NAME_KEY = 3L;
    public static final long NOTE_KEY = 4L;
    private final byte[] seed;
    private final Date birthdate;
    private final String name;
    private final String note;

    public CryptoSeed(byte[] seed, Date birthdate) {
        this(seed, birthdate, null, null);
    }

    public CryptoSeed(byte[] seed, Date birthdate, String name, String note) {
        this.seed = seed;
        this.birthdate = birthdate;
        this.name = name;
        this.note = note;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)new ByteString(this.seed));
        if (this.birthdate != null) {
            UnsignedInteger birthdateItem = new UnsignedInteger(this.birthdate.getTime() / 86400000L);
            birthdateItem.setTag(100L);
            map.put((DataItem)new UnsignedInteger(2L), (DataItem)birthdateItem);
        }
        if (this.name != null) {
            map.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnicodeString(this.name));
        }
        if (this.note != null) {
            map.put((DataItem)new UnsignedInteger(4L), (DataItem)new UnicodeString(this.note));
        }
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_SEED;
    }

    public static CryptoSeed fromCbor(DataItem item) {
        byte[] seed = null;
        Date birthdate = null;
        String name = null;
        String note = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                seed = ((ByteString)map.get(key)).getBytes();
                continue;
            }
            if ((long)intKey == 2L) {
                birthdate = new Date(((UnsignedInteger)map.get(key)).getValue().longValue() * 1000L * 60L * 60L * 24L);
                continue;
            }
            if ((long)intKey == 3L) {
                name = ((UnicodeString)map.get(key)).getString();
                continue;
            }
            if ((long)intKey != 4L) continue;
            note = ((UnicodeString)map.get(key)).getString();
        }
        if (seed == null) {
            throw new IllegalStateException("Seed is null");
        }
        return new CryptoSeed(seed, birthdate, name, note);
    }
}

