/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.util.Arrays;

public class CryptoSskr
extends RegistryItem {
    private final byte[] split;

    public CryptoSskr(byte[] split) {
        this.split = split;
    }

    public byte[] getSplit() {
        return this.split;
    }

    @Override
    public DataItem toCbor() {
        return new ByteString(this.split);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.CRYPTO_SSKR;
    }

    public static CryptoSskr fromCbor(DataItem item) {
        byte[] itemBytes = ((ByteString)item).getBytes();
        byte[] normalisedSplit = Arrays.copyOfRange(itemBytes, 1, itemBytes.length);
        return new CryptoSskr(normalisedSplit);
    }
}

