/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CborSerializable;
import com.sparrowwallet.hummingbird.registry.CryptoECKey;
import com.sparrowwallet.hummingbird.registry.CryptoHDKey;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.util.ArrayList;
import java.util.List;

public class MultiKey
implements CborSerializable {
    public static final int THRESHOLD_KEY = 1;
    public static final int KEYS_KEY = 2;
    private final int threshold;
    private final List<CryptoECKey> ecKeys;
    private final List<CryptoHDKey> hdKeys;

    public MultiKey(int threshold, List<CryptoECKey> ecKeys, List<CryptoHDKey> hdKeys) {
        this.threshold = threshold;
        this.ecKeys = ecKeys;
        this.hdKeys = hdKeys;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public List<CryptoECKey> getEcKeys() {
        return this.ecKeys;
    }

    public List<CryptoHDKey> getHdKeys() {
        return this.hdKeys;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger((long)this.threshold));
        Array array = new Array();
        if (this.ecKeys != null && !this.ecKeys.isEmpty()) {
            for (CryptoECKey cryptoECKey : this.ecKeys) {
                DataItem eckeyItem = cryptoECKey.toCbor();
                eckeyItem.setTag((long)RegistryType.CRYPTO_ECKEY.getTag().intValue());
                array.add(eckeyItem);
            }
        } else if (this.hdKeys != null) {
            for (CryptoHDKey cryptoHDKey : this.hdKeys) {
                DataItem hdkeyItem = cryptoHDKey.toCbor();
                hdkeyItem.setTag((long)RegistryType.CRYPTO_HDKEY.getTag().intValue());
                array.add(hdkeyItem);
            }
        }
        map.put((DataItem)new UnsignedInteger(2L), (DataItem)array);
        return map;
    }

    public static MultiKey fromCbor(DataItem item) {
        int threshold = 0;
        ArrayList<CryptoECKey> ecKeys = new ArrayList<CryptoECKey>();
        ArrayList<CryptoHDKey> hdKeys = new ArrayList<CryptoHDKey>();
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger intKey = (UnsignedInteger)key;
            if (intKey.getValue().intValue() == 1) {
                threshold = ((UnsignedInteger)map.get(key)).getValue().intValue();
            }
            if (intKey.getValue().intValue() != 2) continue;
            Array keysArray = (Array)map.get(key);
            for (DataItem keyExp : keysArray.getDataItems()) {
                if (keyExp.getTag().getValue() == (long)RegistryType.CRYPTO_ECKEY.getTag().intValue()) {
                    ecKeys.add(CryptoECKey.fromCbor(keyExp));
                    continue;
                }
                if (keyExp.getTag().getValue() != (long)RegistryType.CRYPTO_HDKEY.getTag().intValue()) continue;
                hdKeys.add(CryptoHDKey.fromCbor(keyExp));
            }
        }
        if (ecKeys.isEmpty() && hdKeys.isEmpty()) {
            throw new IllegalStateException("One or more of eckey or hdkey must be specified");
        }
        return new MultiKey(threshold, ecKeys, hdKeys);
    }
}

