/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import com.sparrowwallet.hummingbird.UR;
import com.sparrowwallet.hummingbird.registry.CborSerializable;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class RegistryItem
implements CborSerializable {
    public abstract RegistryType getRegistryType();

    public UR toUR() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CborEncoder encoder = new CborEncoder((OutputStream)baos);
            encoder.encode(this.toCbor());
            return new UR(this.getRegistryType(), baos.toByteArray());
        }
        catch (CborException | UR.InvalidTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        int length;
        if (b.signum() < 0) {
            throw new IllegalArgumentException("b must be positive or zero");
        }
        if (numBytes <= 0) {
            throw new IllegalArgumentException("numBytes must be positive");
        }
        byte[] src = b.toByteArray();
        byte[] dest = new byte[numBytes];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int n = length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        if (length > numBytes) {
            throw new IllegalArgumentException("The given number does not fit in " + numBytes);
        }
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = numBytes - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        Arrays.fill(src, (byte)0);
        return dest;
    }
}

