/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.RegistryItem;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.UROutputDescriptor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class URAccountDescriptor
extends RegistryItem {
    public static final long MASTER_FINGERPRINT_KEY = 1L;
    public static final long OUTPUT_DESCRIPTORS_KEY = 2L;
    private final byte[] masterFingerprint;
    private final List<UROutputDescriptor> outputDescriptors;

    public URAccountDescriptor(byte[] masterFingerprint, List<UROutputDescriptor> outputDescriptors) {
        this.masterFingerprint = Arrays.copyOfRange(masterFingerprint, masterFingerprint.length - 4, masterFingerprint.length);
        this.outputDescriptors = outputDescriptors;
    }

    public byte[] getMasterFingerprint() {
        return this.masterFingerprint;
    }

    public List<UROutputDescriptor> getOutputDescriptors() {
        return this.outputDescriptors;
    }

    @Override
    public DataItem toCbor() {
        Map map = new Map();
        map.put((DataItem)new UnsignedInteger(1L), (DataItem)new UnsignedInteger(new BigInteger(1, this.masterFingerprint)));
        Array array = new Array();
        for (UROutputDescriptor outputDescriptor : this.outputDescriptors) {
            DataItem tag;
            DataItem dataItem = outputDescriptor.toCbor();
            Object object = tag = dataItem.getTag() == null ? dataItem : dataItem.getTag();
            while (tag.getTag() != null) {
                tag = tag.getTag();
            }
            tag.setTag((long)RegistryType.OUTPUT_DESCRIPTOR.getTag().intValue());
            array.add(dataItem);
        }
        map.put((DataItem)new UnsignedInteger(2L), (DataItem)array);
        return map;
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.ACCOUNT_DESCRIPTOR;
    }

    public static URAccountDescriptor fromCbor(DataItem cbor) {
        Map accountMap = (Map)cbor;
        UnsignedInteger uintMasterFingerprint = (UnsignedInteger)accountMap.get((DataItem)new UnsignedInteger(1L));
        byte[] masterFingerprint = URAccountDescriptor.bigIntegerToBytes(uintMasterFingerprint.getValue(), 4);
        Array outputDescriptorArray = (Array)accountMap.get((DataItem)new UnsignedInteger(2L));
        ArrayList<UROutputDescriptor> outputDescriptors = new ArrayList<UROutputDescriptor>(outputDescriptorArray.getDataItems().size());
        for (DataItem item : outputDescriptorArray.getDataItems()) {
            outputDescriptors.add(UROutputDescriptor.fromCbor(item));
        }
        return new URAccountDescriptor(masterFingerprint, outputDescriptors);
    }
}

