/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoAddress;
import com.sparrowwallet.hummingbird.registry.CryptoCoinInfo;
import com.sparrowwallet.hummingbird.registry.RegistryType;
import com.sparrowwallet.hummingbird.registry.URCoinInfo;

public class URAddress
extends CryptoAddress {
    public URAddress(CryptoCoinInfo info, CryptoAddress.Type type, byte[] data) {
        super(info, type, data);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.ADDRESS;
    }

    public static URAddress fromCbor(DataItem item) {
        URCoinInfo info = null;
        CryptoAddress.Type type = null;
        byte[] data = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                info = URCoinInfo.fromCbor(map.get(key));
                continue;
            }
            if ((long)intKey == 2L) {
                type = CryptoAddress.Type.values()[((UnsignedInteger)map.get(key)).getValue().intValue()];
                continue;
            }
            if ((long)intKey != 3L) continue;
            data = ((ByteString)map.get(key)).getBytes();
        }
        if (data == null) {
            throw new IllegalStateException("Data is null");
        }
        return new URAddress(info, type, data);
    }
}

