/*
 * Decompiled with CFR 0.152.
 */
package com.sparrowwallet.hummingbird.registry;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.sparrowwallet.hummingbird.registry.CryptoECKey;
import com.sparrowwallet.hummingbird.registry.RegistryType;

public class URECKey
extends CryptoECKey {
    public URECKey(Integer curve, Boolean privateKey, byte[] data) {
        super(curve, privateKey, data);
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.ECKEY;
    }

    public static URECKey fromCbor(DataItem item) {
        Integer curve = null;
        Boolean privateKey = null;
        byte[] data = null;
        Map map = (Map)item;
        for (DataItem key : map.getKeys()) {
            UnsignedInteger uintKey = (UnsignedInteger)key;
            int intKey = uintKey.getValue().intValue();
            if ((long)intKey == 1L) {
                curve = ((UnsignedInteger)map.get(key)).getValue().intValue();
                continue;
            }
            if ((long)intKey == 2L) {
                privateKey = map.get(key) == SimpleValue.TRUE;
                continue;
            }
            if ((long)intKey != 3L) continue;
            data = ((ByteString)map.get(key)).getBytes();
        }
        if (data == null) {
            throw new IllegalStateException("Data is null");
        }
        return new URECKey(curve, privateKey, data);
    }
}

